/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.workorders;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.workorders.IWorkManager;
import com.minecolonies.api.colony.workorders.WorkOrderType;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ColonyUtils;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingMiner;
import com.minecolonies.core.colony.workorders.AbstractWorkOrder;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class WorkOrderMiner
extends AbstractWorkOrder {
    private BlockPos minerBuilding;

    public WorkOrderMiner() {
    }

    public WorkOrderMiner(String packName, String structureName, String workOrderName, RotationMirror rotMir, BlockPos location, boolean keepMirror, BlockPos minerBuilding) {
        super(packName, structureName, workOrderName, WorkOrderType.BUILD, location, keepMirror ? rotMir : RotationMirror.NONE.rotate(rotMir.rotation()), 0, 1);
        this.minerBuilding = minerBuilding;
    }

    @Override
    public void loadBlueprint(Level world, Consumer<Blueprint> afterLoad) {
        if (this.blueprint != null) {
            afterLoad.accept(this.blueprint);
        } else if (this.future == null || this.future.isDone()) {
            this.future = ColonyUtils.queueBlueprintLoad(world, this.getStructurePack(), this.getStructurePath(), blueprint -> {
                this.setBlueprint((Blueprint)blueprint, world);
                afterLoad.accept((Blueprint)blueprint);
            }, error -> {
                this.future = ColonyUtils.queueBlueprintLoad(world, "Minecolonies Original", this.getStructurePath(), blueprint -> {
                    this.setBlueprint((Blueprint)blueprint, world);
                    this.packName = "Minecolonies Original";
                    afterLoad.accept((Blueprint)blueprint);
                });
            });
        }
    }

    @Override
    public boolean canBuild(IBuilding building) {
        return building instanceof BuildingMiner && this.minerBuilding.equals((Object)building.getID());
    }

    @Override
    public boolean canBuildIgnoringDistance(@NotNull IBuilding building, BlockPos position, int level) {
        return this.canBuild(building);
    }

    @Override
    public boolean isValid(IColony colony) {
        return super.isValid(colony) && colony.getBuildingManager().getBuilding(this.minerBuilding) != null;
    }

    @Override
    public void read(@NotNull CompoundTag compound, IWorkManager manager) {
        super.read(compound, manager);
        this.minerBuilding = BlockPosUtil.read(compound, "pos");
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
        super.write(compound);
        BlockPosUtil.write(compound, "pos", this.minerBuilding);
    }

    public BlockPos getMinerBuilding() {
        return this.minerBuilding;
    }
}

