/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.locations;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.colony.requestsystem.location.ILocationFactory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class StaticLocation
implements ILocation {
    private static final int NUMBER_OR_CONTEXTS = 1;
    @NotNull
    private final BlockPos pos;
    private final ResourceKey<Level> dimension;

    public StaticLocation(@NotNull BlockPos pos, ResourceKey<Level> dimension) {
        this.pos = pos;
        this.dimension = dimension;
    }

    @Override
    @NotNull
    public BlockPos getInDimensionLocation() {
        return this.pos;
    }

    @Override
    @NotNull
    public ResourceKey<Level> getDimension() {
        return this.dimension;
    }

    @Override
    public boolean isReachableFromLocation(@NotNull ILocation location) {
        return location.getDimension() == this.getDimension();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof StaticLocation)) {
            return false;
        }
        StaticLocation that = (StaticLocation)o;
        if (this.getDimension() != that.getDimension()) {
            return false;
        }
        return this.pos.equals((Object)that.pos);
    }

    public int hashCode() {
        int result = this.pos.hashCode();
        result = 31 * result + this.getDimension().location().toString().hashCode();
        return result;
    }

    public String toString() {
        return "Dim: " + String.valueOf(this.dimension.location()) + " " + this.pos.getX() + " " + this.pos.getY() + " " + this.pos.getZ() + " ";
    }

    public static void serialize(RegistryFriendlyByteBuf buffer, StaticLocation location) {
        buffer.writeBlockPos(location.pos);
        buffer.writeUtf(location.dimension.location().toString());
    }

    public static StaticLocation deserialize(RegistryFriendlyByteBuf buffer) {
        BlockPos pos = buffer.readBlockPos();
        ResourceLocation dimension = ResourceLocation.parse((String)buffer.readUtf(Short.MAX_VALUE));
        return new StaticLocation(pos, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)dimension));
    }

    public static class Factory
    implements ILocationFactory<BlockPos, StaticLocation> {
        private static final String NBT_POS = "Pos";
        private static final String NBT_DIM = "Dim";

        @Override
        @NotNull
        public TypeToken<StaticLocation> getFactoryOutputType() {
            return TypeToken.of(StaticLocation.class);
        }

        @Override
        @NotNull
        public TypeToken<BlockPos> getFactoryInputType() {
            return TypeToken.of(BlockPos.class);
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull StaticLocation request) {
            CompoundTag compound = new CompoundTag();
            compound.putLong(NBT_POS, request.getInDimensionLocation().asLong());
            compound.putString(NBT_DIM, request.getDimension().location().toString());
            return compound;
        }

        @Override
        @NotNull
        public StaticLocation deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) {
            BlockPos pos = BlockPos.of((long)nbt.getLong(NBT_POS));
            String dim = nbt.getString(NBT_DIM);
            return new StaticLocation(pos, (ResourceKey<Level>)ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)dim)));
        }

        @Override
        @NotNull
        public StaticLocation getNewInstance(@NotNull IFactoryController factoryController, @NotNull BlockPos blockPos, Object ... context) {
            if (context.length != 1) {
                throw new IllegalArgumentException("Unsupported context - Not the correct amount available. Needed is 1!");
            }
            if (!(context[0] instanceof ResourceKey)) {
                throw new IllegalArgumentException("Unsupported context - First context object is not a ResourceLocation. Provide an ResourceLocation as Dimension.");
            }
            return new StaticLocation(blockPos, (ResourceKey<Level>)((ResourceKey)context[0]));
        }

        @Override
        @NotNull
        public StaticLocation getNewInstance(@NotNull IFactoryController factoryController, @NotNull BlockPos input) {
            return new StaticLocation(input, (ResourceKey<Level>)Level.OVERWORLD);
        }

        @Override
        public void serialize(@NotNull IFactoryController controller, @NotNull StaticLocation input, RegistryFriendlyByteBuf packetBuffer) {
            StaticLocation.serialize(packetBuffer, input);
        }

        @Override
        @NotNull
        public StaticLocation deserialize(@NotNull IFactoryController controller, @NotNull RegistryFriendlyByteBuf buffer) throws Throwable {
            return StaticLocation.deserialize(buffer);
        }

        @Override
        public short getSerializationId() {
            return 3;
        }
    }
}

