/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.data;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IProviderResolverAssignmentDataStore;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.util.Tuple;
import org.jetbrains.annotations.NotNull;

public class StandardProviderRequestResolverAssignmentDataStore
implements IProviderResolverAssignmentDataStore {
    private final Map<IToken<?>, Collection<IToken<?>>> assignments;
    private IToken<?> id;

    public StandardProviderRequestResolverAssignmentDataStore(IToken<?> id, Map<IToken<?>, Collection<IToken<?>>> assignments) {
        this.id = id;
        this.assignments = assignments;
    }

    public StandardProviderRequestResolverAssignmentDataStore() {
        this(StandardFactoryController.getInstance().getNewInstance(TypeConstants.ITOKEN), new HashMap());
    }

    @Override
    @NotNull
    public Map<IToken<?>, Collection<IToken<?>>> getAssignments() {
        return this.assignments;
    }

    @Override
    public IToken<?> getId() {
        return this.id;
    }

    @Override
    public void setId(IToken<?> id) {
        this.id = id;
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardProviderRequestResolverAssignmentDataStore> {
        @Override
        @NotNull
        public TypeToken<? extends StandardProviderRequestResolverAssignmentDataStore> getFactoryOutputType() {
            return TypeToken.of(StandardProviderRequestResolverAssignmentDataStore.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardProviderRequestResolverAssignmentDataStore getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardProviderRequestResolverAssignmentDataStore();
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull StandardProviderRequestResolverAssignmentDataStore standardProviderRequestResolverAssignmentDataStore) {
            CompoundTag compound = new CompoundTag();
            compound.put("Token", (Tag)controller.serializeTag(provider, standardProviderRequestResolverAssignmentDataStore.id));
            compound.put("List", (Tag)standardProviderRequestResolverAssignmentDataStore.assignments.keySet().stream().map(t -> {
                CompoundTag entryCompound = new CompoundTag();
                entryCompound.put("Token", (Tag)controller.serializeTag(provider, t));
                entryCompound.put("List", (Tag)standardProviderRequestResolverAssignmentDataStore.assignments.get(t).stream().map(s -> StandardFactoryController.getInstance().serializeTag(provider, s)).collect(NBTUtils.toListNBT()));
                return entryCompound;
            }).collect(NBTUtils.toListNBT()));
            return compound;
        }

        @Override
        @NotNull
        public StandardProviderRequestResolverAssignmentDataStore deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) throws Throwable {
            IToken token = (IToken)controller.deserializeTag(provider, nbt.getCompound("Token"));
            Map<IToken<?>, Collection<IToken<?>>> map = NBTUtils.streamCompound(nbt.getList("List", 10)).map(CompoundTag2 -> {
                IToken elementToken = (IToken)controller.deserializeTag(provider, CompoundTag2.getCompound("Token"));
                Collection elements = NBTUtils.streamCompound(CompoundTag2.getList("List", 10)).map(elementCompound -> (IToken)controller.deserializeTag(provider, (CompoundTag)elementCompound)).collect(Collectors.toList());
                return new Tuple((Object)elementToken, (Object)elements);
            }).collect(Collectors.toMap(t -> (IToken)t.getA(), t -> (Collection)t.getB()));
            return new StandardProviderRequestResolverAssignmentDataStore(token, map);
        }

        @Override
        public void serialize(IFactoryController controller, StandardProviderRequestResolverAssignmentDataStore input, RegistryFriendlyByteBuf packetBuffer) {
            controller.serialize(packetBuffer, input.id);
            packetBuffer.writeInt(input.assignments.size());
            input.assignments.forEach((key, value) -> {
                controller.serialize(packetBuffer, key);
                packetBuffer.writeInt(value.size());
                value.forEach(token -> controller.serialize(packetBuffer, token));
            });
        }

        @Override
        public StandardProviderRequestResolverAssignmentDataStore deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) throws Throwable {
            IToken token = (IToken)controller.deserialize(buffer);
            HashMap assignments = new HashMap();
            int assignmentsSize = buffer.readInt();
            for (int i = 0; i < assignmentsSize; ++i) {
                IToken key = (IToken)controller.deserialize(buffer);
                ArrayList<IToken> tokens = new ArrayList<IToken>();
                int tokensSize = buffer.readInt();
                for (int ii = 0; ii < tokensSize; ++ii) {
                    tokens.add((IToken)controller.deserialize(buffer));
                }
                assignments.put(key, tokens);
            }
            return new StandardProviderRequestResolverAssignmentDataStore(token, assignments);
        }

        @Override
        public short getSerializationId() {
            return 34;
        }
    }
}

