/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.data;

import com.google.common.reflect.TypeToken;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.data.IDataStore;
import com.minecolonies.api.colony.requestsystem.data.IDataStoreManager;
import com.minecolonies.api.colony.requestsystem.factory.FactoryVoidInput;
import com.minecolonies.api.colony.requestsystem.factory.IFactory;
import com.minecolonies.api.colony.requestsystem.factory.IFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class StandardDataStoreManager
implements IDataStoreManager {
    private final Map<IToken<?>, IDataStore> storeMap;

    public StandardDataStoreManager(Map<IToken<?>, IDataStore> storeMap) {
        this.storeMap = storeMap;
    }

    public StandardDataStoreManager() {
        this(new HashMap());
    }

    @Override
    public <T extends IDataStore> T get(IToken<?> id, TypeToken<T> type) {
        return (T)this.get(id, () -> (IDataStore)StandardFactoryController.getInstance().getNewInstance(type));
    }

    @Override
    public <T extends IDataStore> T get(IToken<?> id, Supplier<T> factory) {
        if (!this.storeMap.containsKey(id)) {
            IDataStore defaultInstance = (IDataStore)factory.get();
            defaultInstance.setId(id);
            this.storeMap.put(id, defaultInstance);
        }
        return (T)this.storeMap.get(id);
    }

    @Override
    public void remove(IToken<?> id) {
        this.storeMap.remove(id);
    }

    @Override
    public void removeAll() {
        this.storeMap.clear();
    }

    public static class Factory
    implements IFactory<FactoryVoidInput, StandardDataStoreManager> {
        @Override
        @NotNull
        public TypeToken<? extends StandardDataStoreManager> getFactoryOutputType() {
            return TypeToken.of(StandardDataStoreManager.class);
        }

        @Override
        @NotNull
        public TypeToken<? extends FactoryVoidInput> getFactoryInputType() {
            return TypeConstants.FACTORYVOIDINPUT;
        }

        @Override
        @NotNull
        public StandardDataStoreManager getNewInstance(@NotNull IFactoryController factoryController, @NotNull FactoryVoidInput factoryVoidInput, Object ... context) throws IllegalArgumentException {
            return new StandardDataStoreManager();
        }

        @Override
        @NotNull
        public CompoundTag serialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull StandardDataStoreManager standardDataStoreManager) {
            CompoundTag compound = new CompoundTag();
            compound.put("List", (Tag)standardDataStoreManager.storeMap.keySet().stream().map(iToken -> {
                CompoundTag entryCompound = new CompoundTag();
                entryCompound.put("Token", (Tag)controller.serializeTag(provider, iToken));
                entryCompound.put("Value", (Tag)controller.serializeTag(provider, standardDataStoreManager.storeMap.get(iToken)));
                return entryCompound;
            }).collect(NBTUtils.toListNBT()));
            return compound;
        }

        @Override
        @NotNull
        public StandardDataStoreManager deserialize(@NotNull HolderLookup.Provider provider, @NotNull IFactoryController controller, @NotNull CompoundTag nbt) throws Throwable {
            HashMap storeMap = new HashMap();
            ListTag list = nbt.getList("List", 10);
            for (int i = 0; i < list.size(); ++i) {
                CompoundTag tag = list.getCompound(i);
                try {
                    IToken token = (IToken)controller.deserializeTag(provider, tag.getCompound("Token"));
                    IDataStore store = (IDataStore)controller.deserializeTag(provider, tag.getCompound("Value"));
                    storeMap.put(token, store);
                    continue;
                }
                catch (Exception ex) {
                    Log.getLogger().error((Object)ex);
                }
            }
            return new StandardDataStoreManager(storeMap);
        }

        @Override
        public void serialize(IFactoryController controller, StandardDataStoreManager input, RegistryFriendlyByteBuf packetBuffer) {
            packetBuffer.writeInt(input.storeMap.size());
            input.storeMap.forEach((key, value) -> {
                controller.serialize(packetBuffer, key);
                controller.serialize(packetBuffer, value);
            });
        }

        @Override
        public StandardDataStoreManager deserialize(IFactoryController controller, RegistryFriendlyByteBuf buffer) {
            HashMap storeMap = new HashMap();
            int storeSize = buffer.readInt();
            for (int i = 0; i < storeSize; ++i) {
                try {
                    storeMap.put((IToken)controller.deserialize(buffer), (IDataStore)controller.deserialize(buffer));
                    continue;
                }
                catch (Exception ex) {
                    Log.getLogger().error((Object)ex);
                }
            }
            return new StandardDataStoreManager(storeMap);
        }

        @Override
        public short getSerializationId() {
            return 40;
        }
    }
}

