/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.jobs;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.ai.statemachine.states.AIWorkerState;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.util.constant.CitizenConstants;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.jobs.AbstractJob;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import com.minecolonies.core.util.AttributeModifierUtils;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;

public abstract class AbstractJobGuard<J extends AbstractJobGuard<J>>
extends AbstractJob<AbstractEntityAIGuard<J, ? extends AbstractBuildingGuards>, J> {
    public AbstractJobGuard(ICitizenData entity) {
        super(entity);
    }

    protected abstract AbstractEntityAIGuard<J, ? extends AbstractBuildingGuards> generateGuardAI();

    @Override
    public AbstractEntityAIGuard<J, ? extends AbstractBuildingGuards> generateAI() {
        return this.generateGuardAI();
    }

    @Override
    public void triggerDeathAchievement(DamageSource source, AbstractEntityCitizen citizen) {
        super.triggerDeathAchievement(source, citizen);
    }

    @Override
    public boolean allowsAvoidance() {
        return false;
    }

    @Override
    public boolean isGuard() {
        return true;
    }

    public boolean isAsleep() {
        return this.getWorkerAI() != null && ((AbstractEntityAIGuard)this.getWorkerAI()).getState() == AIWorkerState.GUARD_SLEEP;
    }

    @Override
    public void initEntityValues(AbstractEntityCitizen citizen) {
        super.initEntityValues(citizen);
        IBuilding workBuilding = citizen.getCitizenData().getWorkBuilding();
        if (workBuilding instanceof AbstractBuildingGuards) {
            AttributeModifierUtils.addHealthModifier((LivingEntity)citizen, new AttributeModifier(CitizenConstants.GUARD_HEALTH_MOD_BUILDING_NAME, (double)((AbstractBuildingGuards)workBuilding).getBonusHealth(), AttributeModifier.Operation.ADD_VALUE));
            AttributeModifierUtils.addHealthModifier((LivingEntity)citizen, new AttributeModifier(CitizenConstants.GUARD_HEALTH_MOD_CONFIG_NAME, (Double)((ServerConfiguration)MineColonies.getConfig().getServer()).guardHealthMult.get() - 1.0, AttributeModifier.Operation.ADD_MULTIPLIED_TOTAL));
        }
    }

    @Override
    public double getSaturationFactor() {
        return 1.2;
    }
}

