/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings.plantation.modules.generic;

import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildingextensions.plantation.IPlantationModule;
import com.minecolonies.core.colony.buildings.workerbuildings.plantation.AbstractPlantationModule;
import com.minecolonies.core.util.CollectorUtils;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TreeSidePlantModule
extends AbstractPlantationModule {
    protected TreeSidePlantModule(IBuildingExtension field, String fieldTag, String workTag, Item item) {
        super(field, fieldTag, workTag, item);
    }

    @Override
    public IPlantationModule.PlantationModuleResult.Builder decideFieldWork(Level world, @NotNull BlockPos workingPosition) {
        IPlantationModule.ActionToPerform action = this.decideWorkAction(world, workingPosition);
        return switch (action) {
            case IPlantationModule.ActionToPerform.HARVEST -> new IPlantationModule.PlantationModuleResult.Builder().harvest(workingPosition).pickNewPosition();
            case IPlantationModule.ActionToPerform.PLANT -> new IPlantationModule.PlantationModuleResult.Builder().plant(workingPosition).pickNewPosition();
            case IPlantationModule.ActionToPerform.CLEAR -> new IPlantationModule.PlantationModuleResult.Builder().clear(workingPosition).pickNewPosition();
            default -> IPlantationModule.PlantationModuleResult.NONE;
        };
    }

    private IPlantationModule.ActionToPerform decideWorkAction(Level world, BlockPos plantingPosition) {
        BlockState blockState = world.getBlockState(plantingPosition);
        if (this.isValidPlantingBlock(blockState)) {
            return IPlantationModule.ActionToPerform.PLANT;
        }
        if (this.isValidClearingBlock(blockState)) {
            return IPlantationModule.ActionToPerform.CLEAR;
        }
        if (this.isValidHarvestBlock(blockState)) {
            return IPlantationModule.ActionToPerform.HARVEST;
        }
        return IPlantationModule.ActionToPerform.NONE;
    }

    protected boolean isValidPlantingBlock(BlockState blockState) {
        return blockState.isAir();
    }

    protected boolean isValidClearingBlock(BlockState blockState) {
        return !this.isValidHarvestBlock(blockState);
    }

    protected abstract boolean isValidHarvestBlock(BlockState var1);

    @Override
    @Nullable
    public BlockPos getNextWorkingPosition(Level world) {
        for (BlockPos position : this.getWorkingPositions()) {
            if (this.decideWorkAction(world, position) == IPlantationModule.ActionToPerform.NONE) continue;
            return position;
        }
        return null;
    }

    @Override
    public int getActionLimit() {
        return 5;
    }

    @Override
    public List<ItemStack> getRequiredItemsForOperation() {
        return List.of(new ItemStack((ItemLike)this.getItem()));
    }

    @Override
    public List<BlockPos> getValidWorkingPositions(@NotNull Level world, List<BlockPos> workingPositions) {
        HashSet<BlockPos> treePositions = new HashSet<BlockPos>();
        for (BlockPos position : workingPositions) {
            for (BlockPos adjacentPosition : List.of(position.north(), position.south(), position.west(), position.east())) {
                if (!world.getBlockState(adjacentPosition).isAir()) continue;
                treePositions.add(adjacentPosition);
            }
        }
        return super.getValidWorkingPositions(world, treePositions.stream().collect(CollectorUtils.toShuffledList()));
    }

    @Override
    public BlockPos getPositionToWalkTo(Level world, BlockPos workingPosition) {
        return Stream.of(workingPosition.north(), workingPosition.south(), workingPosition.west(), workingPosition.east()).filter(pos -> world.getBlockState(pos).isAir()).findFirst().orElse(workingPosition);
    }
}

