/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.WoolCarpetBlock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BuildingSchool
extends AbstractBuilding {
    private static final String SCHOOL = "school";
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String TAG_CARPET = "carpet";
    @NotNull
    private final List<BlockPos> carpet = new ArrayList<BlockPos>();
    private final Random random = new Random();

    public BuildingSchool(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return SCHOOL;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void registerBlockPosition(@NotNull Block block, @NotNull BlockPos pos, @NotNull Level world) {
        super.registerBlockPosition(block, pos, world);
        if (block instanceof WoolCarpetBlock) {
            this.carpet.add(pos);
        }
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        ListTag carpetTagList = compound.getList(TAG_CARPET, 10);
        for (int i = 0; i < carpetTagList.size(); ++i) {
            CompoundTag bedCompound = carpetTagList.getCompound(i);
            BlockPos pos = BlockPosUtil.read(bedCompound, "pos");
            if (this.carpet.contains(pos)) continue;
            this.carpet.add(pos);
        }
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        if (!this.carpet.isEmpty()) {
            @NotNull ListTag carpetTagList = new ListTag();
            for (BlockPos pos : this.carpet) {
                CompoundTag carpetCompound = new CompoundTag();
                BlockPosUtil.write(carpetCompound, "pos", pos);
                carpetTagList.add((Object)carpetCompound);
            }
            compound.put(TAG_CARPET, (Tag)carpetTagList);
        }
        return compound;
    }

    @Nullable
    public BlockPos getRandomPlaceToSit() {
        if (this.carpet.isEmpty()) {
            return null;
        }
        BlockPos returnPos = this.carpet.get(this.random.nextInt(this.carpet.size()));
        if (this.colony.getWorld().getBlockState(returnPos).getBlock() instanceof WoolCarpetBlock) {
            return returnPos;
        }
        this.carpet.remove(returnPos);
        return null;
    }
}

