/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.modules.IItemListModule;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.jobs.registry.JobEntry;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.colony.buildings.modules.ItemListModule;
import com.minecolonies.core.colony.buildings.modules.WorkerBuildingModule;
import com.minecolonies.core.colony.buildings.modules.settings.BoolSetting;
import com.minecolonies.core.colony.buildings.modules.settings.DynamicTreesSetting;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class BuildingLumberjack
extends AbstractBuilding {
    public static final ISettingKey<BoolSetting> REPLANT = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "replant"));
    public static final ISettingKey<BoolSetting> RESTRICT = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "restrict"));
    public static final ISettingKey<BoolSetting> DEFOLIATE = new SettingKey<BoolSetting>(BoolSetting.class, new ResourceLocation("minecolonies", "defoliate"));
    public static final ISettingKey<DynamicTreesSetting> DYNAMIC_TREES_SIZE = new SettingKey<DynamicTreesSetting>(DynamicTreesSetting.class, new ResourceLocation("minecolonies", "dynamictreeharvestsize"));
    private static final String TAG_RESTRICT_START = "startRestrictionPosition";
    private static final String TAG_RESTRICT_END = "endRestrictionPosition";
    private BlockPos startRestriction = null;
    private BlockPos endRestriction = null;
    private static final int MAX_BUILDING_LEVEL = 5;
    private static final String LUMBERJACK = "lumberjack";
    private final Set<BlockPos> netherTrees = new HashSet<BlockPos>();
    private static final int FUNGI_MODIFIER = 10;

    public BuildingLumberjack(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.axe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.shears.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    public boolean canBeGathered() {
        return true;
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>> toKeep = new HashMap<Predicate<ItemStack>, Tuple<Integer, Boolean>>(super.getRequiredItemsAndAmount());
        IItemListModule saplingList = (IItemListModule)this.getModuleMatching(ItemListModule.class, m -> m.getId().equals("saplings"));
        for (ItemStorage sapling : IColonyManager.getInstance().getCompatibilityManager().getCopyOfSaplings()) {
            if (saplingList.isItemInList(sapling)) continue;
            toKeep.put(stack -> ItemStackUtils.compareItemStacksIgnoreStackSize(sapling.getItemStack(), stack), (Tuple<Integer, Boolean>)new Tuple((Object)64, (Object)true));
        }
        return toKeep;
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return LUMBERJACK;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        this.startRestriction = compound.contains(TAG_RESTRICT_START) ? NBTUtils.readBlockPos(compound, TAG_RESTRICT_START) : null;
        this.endRestriction = compound.contains(TAG_RESTRICT_END) ? NBTUtils.readBlockPos(compound, TAG_RESTRICT_END) : null;
        ListTag netherTreeBinTagList = compound.getList("netherTrees", 10);
        for (int i = 0; i < netherTreeBinTagList.size(); ++i) {
            this.netherTrees.add(BlockPosUtil.readFromListNBT(netherTreeBinTagList, i));
        }
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        if (this.startRestriction != null) {
            compound.put(TAG_RESTRICT_START, NBTUtils.writeBlockPos(this.startRestriction));
        }
        if (this.endRestriction != null) {
            compound.put(TAG_RESTRICT_END, NBTUtils.writeBlockPos(this.endRestriction));
        }
        @NotNull ListTag netherTreeBinCompoundList = new ListTag();
        for (BlockPos pos : this.netherTrees) {
            BlockPosUtil.writeToListNBT(netherTreeBinCompoundList, pos);
        }
        compound.put("netherTrees", (Tag)netherTreeBinCompoundList);
        return compound;
    }

    public boolean shouldReplant() {
        return this.getSetting(REPLANT).getValue();
    }

    public boolean shouldDefoliate() {
        return this.getSetting(DEFOLIATE).getValue();
    }

    public boolean shouldRestrict() {
        if (this.getSetting(RESTRICT).getValue().booleanValue() && (this.startRestriction == null || this.endRestriction == null)) {
            this.getSetting(RESTRICT).trigger();
            this.markDirty();
        }
        return this.getSetting(RESTRICT).getValue();
    }

    public void setRestrictedArea(BlockPos startPosition, BlockPos endPosition) {
        boolean areaIsDefined;
        this.startRestriction = startPosition;
        this.endRestriction = endPosition;
        boolean bl = areaIsDefined = startPosition != null && endPosition != null;
        if (this.getSetting(RESTRICT).getValue() != areaIsDefined) {
            this.getSetting(RESTRICT).trigger();
        }
        this.markDirty();
    }

    public BlockPos getStartRestriction() {
        return this.startRestriction;
    }

    public BlockPos getEndRestriction() {
        return this.endRestriction;
    }

    private void bonemealFungi() {
        WorkerBuildingModule module = (WorkerBuildingModule)this.getFirstModuleOccurance(WorkerBuildingModule.class);
        ICitizenData data = ((WorkerBuildingModule)this.getFirstModuleOccurance(WorkerBuildingModule.class)).getFirstCitizen();
        if (data == null) {
            return;
        }
        int modifier = Math.max(0, Math.min(10, 100));
        Iterator<BlockPos> iterator = this.netherTrees.iterator();
        while (iterator.hasNext()) {
            BlockPos pos = iterator.next();
            Level world = this.colony.getWorld();
            if (!WorldUtil.isBlockLoaded((LevelAccessor)world, pos)) continue;
            BlockState blockState = world.getBlockState(pos);
            Block block = blockState.getBlock();
            if (blockState.is(ModTags.mushroomBlocks) || blockState.is(ModTags.fungiBlocks)) {
                BonemealableBlock growable;
                int threshold = modifier + (int)Math.ceil((float)data.getCitizenSkillHandler().getLevel(module.getPrimarySkill()) * (1.0f - (float)modifier / 100.0f));
                int rand = world.getRandom().nextInt(100);
                if (rand >= threshold || !(growable = (BonemealableBlock)block).isValidBonemealTarget((LevelReader)world, pos, blockState) || world.isClientSide || !growable.isBonemealSuccess(world, world.random, pos, blockState)) continue;
                growable.performBonemeal((ServerLevel)world, world.random, pos, blockState);
                return;
            }
            iterator.remove();
        }
    }

    public Set<BlockPos> getNetherTrees() {
        return new HashSet<BlockPos>(this.netherTrees);
    }

    public void removeNetherTree(BlockPos pos) {
        this.netherTrees.remove(pos);
    }

    public void addNetherTree(BlockPos pos) {
        this.netherTrees.add(pos);
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        super.onColonyTick(colony);
        this.bonemealFungi();
    }

    @Override
    public void serializeToView(@NotNull RegistryFriendlyByteBuf buf, boolean fullSync) {
        super.serializeToView(buf, fullSync);
        buf.writeBoolean(this.shouldRestrict());
        if (this.startRestriction != null && this.endRestriction != null) {
            buf.writeBlockPos(this.startRestriction);
            buf.writeBlockPos(this.endRestriction);
        } else {
            buf.writeBlockPos(BlockPos.ZERO);
            buf.writeBlockPos(BlockPos.ZERO);
        }
    }

    public static class CraftingModule
    extends AbstractCraftingBuildingModule.Custom {
        public CraftingModule(JobEntry jobEntry) {
            super(jobEntry);
        }

        @Override
        public boolean canRecipeBeAdded(@NotNull IToken<?> token) {
            return false;
        }
    }

    public static class View
    extends AbstractBuildingView {
        private boolean restrict;
        private BlockPos startRestriction;
        private BlockPos endRestriction;

        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
            super.deserialize(buf);
            this.restrict = buf.readBoolean();
            this.startRestriction = buf.readBlockPos();
            this.endRestriction = buf.readBlockPos();
        }

        public boolean shouldRestrict() {
            return this.restrict;
        }

        public BlockPos getStartRestriction() {
            return this.startRestriction;
        }

        public BlockPos getEndRestriction() {
            return this.endRestriction;
        }
    }
}

