/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.moduleviews;

import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.core.network.messages.server.colony.building.fields.AssignFieldMessage;
import com.minecolonies.core.network.messages.server.colony.building.fields.AssignmentModeMessage;
import java.util.Comparator;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FieldsModuleView
extends AbstractBuildingModuleView {
    private boolean shouldAssignFieldManually;
    private int maxFieldCount;

    @Override
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        this.shouldAssignFieldManually = buf.readBoolean();
        this.maxFieldCount = buf.readInt();
    }

    @Override
    public ResourceLocation getIconResourceLocation() {
        return new ResourceLocation("minecolonies", "textures/gui/modules/field.png");
    }

    @Override
    public Component getDesc() {
        return Component.translatable((String)"com.minecolonies.coremod.gui.workerhuts.fields");
    }

    public boolean assignFieldManually() {
        return this.shouldAssignFieldManually;
    }

    public void setAssignFieldManually(boolean assignFieldManually) {
        this.shouldAssignFieldManually = assignFieldManually;
        new AssignmentModeMessage(this.buildingView, assignFieldManually, this.getProducer().getRuntimeID()).sendToServer();
    }

    public void assignField(IBuildingExtension field) {
        if (this.buildingView != null && this.canAssignField(field)) {
            new AssignFieldMessage(this.buildingView, field, true, this.getProducer().getRuntimeID()).sendToServer();
            WorkerBuildingModuleView buildingModuleView = this.buildingView.getModuleViewMatching(WorkerBuildingModuleView.class, view -> true);
            if (buildingModuleView != null) {
                field.setBuilding(this.buildingView.getID());
            }
        }
    }

    public final boolean canAssignField(IBuildingExtension field) {
        return this.getOwnedFields().size() < this.maxFieldCount && this.canAssignFieldOverride(field);
    }

    @NotNull
    public List<IBuildingExtension> getOwnedFields() {
        return this.getFields().stream().filter(field -> this.buildingView.getID().equals((Object)field.getBuildingId())).distinct().sorted(new FieldsComparator(this.buildingView)).toList();
    }

    protected abstract boolean canAssignFieldOverride(IBuildingExtension var1);

    @NotNull
    public List<IBuildingExtension> getFields() {
        return this.getFieldsInColony().stream().filter(field -> !field.isTaken() || this.buildingView.getID().equals((Object)field.getBuildingId())).distinct().sorted(new FieldsComparator(this.buildingView)).toList();
    }

    protected abstract List<IBuildingExtension> getFieldsInColony();

    public void freeField(IBuildingExtension field) {
        if (this.buildingView != null) {
            new AssignFieldMessage(this.buildingView, field, false, this.getProducer().getRuntimeID()).sendToServer();
            WorkerBuildingModuleView buildingModuleView = this.buildingView.getModuleViewMatching(WorkerBuildingModuleView.class, view -> true);
            if (buildingModuleView != null) {
                field.resetOwningBuilding();
            }
        }
    }

    @Nullable
    public MutableComponent getFieldWarningTooltip(IBuildingExtension field) {
        if (this.getOwnedFields().size() >= this.maxFieldCount) {
            return Component.translatableEscape((String)"com.minecolonies.coremod.gui.workerhuts.fields.fieldcount.reached", (Object[])new Object[0]);
        }
        return null;
    }

    public int getMaxFieldCount() {
        return this.maxFieldCount;
    }

    static class FieldsComparator
    implements Comparator<IBuildingExtension> {
        private final IBuildingView assignedBuilding;

        public FieldsComparator(IBuildingView assignedBuilding) {
            this.assignedBuilding = assignedBuilding;
        }

        @Override
        public int compare(IBuildingExtension field1, IBuildingExtension field2) {
            if (field1.isTaken() && field2.isTaken()) {
                return field1.getSqDistance(this.assignedBuilding) - field2.getSqDistance(this.assignedBuilding);
            }
            if (field1.isTaken()) {
                return -1;
            }
            if (field2.isTaken()) {
                return 1;
            }
            return field1.getSqDistance(this.assignedBuilding) - field2.getSqDistance(this.assignedBuilding);
        }
    }
}

