/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules.settings;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.views.BOWindow;
import com.ldtteam.structurize.client.gui.WindowSelectRes;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.modules.settings.ISetting;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingsModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockSetting
implements ISetting<BlockItem> {
    private final BlockItem defaultValue;
    private BlockItem value;

    public BlockSetting(BlockItem init) {
        this.value = init;
        this.defaultValue = init;
    }

    public BlockSetting(BlockItem value, BlockItem def) {
        this.value = value;
        this.defaultValue = def;
    }

    @Override
    public BlockItem getValue() {
        return this.value;
    }

    public BlockItem getDefault() {
        return this.defaultValue;
    }

    public void setValue(BlockItem value) {
        this.value = value;
    }

    @Override
    public ResourceLocation getLayoutItem() {
        return new ResourceLocation("minecolonies", "gui/layouthuts/layoutblocksetting.xml");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void setupHandler(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        ((ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class)).setHandler(button -> new WindowSelectRes(window, (Component)Component.empty(), new ItemStack((ItemLike)this.value), IColonyManager.getInstance().getCompatibilityManager().getListOfMatchingItems(stack -> {
            Item item = stack.getItem();
            if (!(item instanceof BlockItem)) {
                return false;
            }
            Block block = ((BlockItem)item).getBlock();
            BlockState state = block.defaultBlockState();
            if (block instanceof EntityBlock || block instanceof FallingBlock || state.is(BlockTags.LEAVES)) {
                return false;
            }
            return state.getShape((BlockGetter)new SingleStateBlockGetter(this, state), BlockPos.ZERO, CollisionContext.empty()).equals(Shapes.block()) && state.blocksMotion();
        }), (stack, qty) -> {
            if (stack.isEmpty()) {
                return;
            }
            this.value = (BlockItem)stack.getItem();
            settingsModuleView.getSetting(new SettingKey(key.getType(), key.getUniqueId())).updateSetting(this);
            settingsModuleView.trigger(key);
        }).open());
    }

    @Override
    public void render(ISettingKey<?> key, Pane pane, ISettingsModuleView settingsModuleView, IBuildingView building, BOWindow window) {
        ((ItemIcon)pane.findPaneOfTypeByID("icon", ItemIcon.class)).setItem(new ItemStack((ItemLike)this.value));
        ButtonImage triggerButton = (ButtonImage)pane.findPaneOfTypeByID("trigger", ButtonImage.class);
        triggerButton.setEnabled(this.isActive(settingsModuleView));
        triggerButton.setText(Component.translatable((String)"com.minecolonies.coremod.gui.workerhuts.switch"));
        this.setHoverPane(key, (Pane)triggerButton, settingsModuleView);
    }

    @Override
    public void copyValue(ISetting<?> setting) {
        if (setting instanceof BlockSetting) {
            BlockSetting other = (BlockSetting)setting;
            this.setValue(other.getValue());
        }
    }

    public class SingleStateBlockGetter
    implements BlockGetter {
        private final BlockState state;

        public SingleStateBlockGetter(BlockSetting this$0, BlockState state) {
            this.state = state;
        }

        @Nullable
        public BlockEntity getBlockEntity(@NotNull BlockPos pos) {
            return null;
        }

        @NotNull
        public BlockState getBlockState(@NotNull BlockPos pos) {
            if (pos == BlockPos.ZERO) {
                return this.state;
            }
            return Blocks.AIR.defaultBlockState();
        }

        @NotNull
        public FluidState getFluidState(@NotNull BlockPos pos) {
            return Fluids.EMPTY.defaultFluidState();
        }

        public int getHeight() {
            return Integer.MAX_VALUE;
        }

        public int getMinBuildHeight() {
            return Integer.MIN_VALUE;
        }
    }
}

