/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules.building;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.AbstractTextBuilder;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ButtonImage;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.workorders.IWorkOrder;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import com.minecolonies.core.colony.buildings.moduleviews.SettingsModuleView;
import com.minecolonies.core.colony.buildings.moduleviews.WorkOrderListModuleView;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingBuilder;
import com.minecolonies.core.network.messages.server.colony.WorkOrderChangeMessage;
import com.minecolonies.core.network.messages.server.colony.building.builder.BuilderSelectWorkOrderMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class WorkOrderModuleWindow
extends AbstractModuleWindow<WorkOrderListModuleView> {
    private final List<IWorkOrderView> workOrders = new ArrayList<IWorkOrderView>();
    private ScrollingList workOrdersList;
    private boolean manualMode;
    private int tick = 0;

    public WorkOrderModuleWindow(WorkOrderListModuleView moduleView) {
        super(moduleView, new ResourceLocation("minecolonies", "gui/layouthuts/layoutworkorders.xml"));
        this.registerButton("manage", this::selectWorkOrder);
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.manualMode = this.buildingView.getModuleViewByType(SettingsModuleView.class).getSetting(BuildingBuilder.MODE).getValue().equals("com.minecolonies.core.builder.setting.manual");
        this.workOrdersList = (ScrollingList)this.findPaneOfTypeByID("workOrders", ScrollingList.class);
        this.workOrdersList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WorkOrderModuleWindow.this.workOrders.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                WorkOrderModuleWindow.this.updateAvailableWorkOrders(index, rowPane);
            }
        });
        this.updateWorkOrders();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.tick++ == 20) {
            this.tick = 0;
            this.updateWorkOrders();
        }
    }

    private void updateWorkOrders() {
        Predicate<IWorkOrderView> shouldShow = wo -> wo.shouldShowIn(this.buildingView);
        Predicate<IWorkOrderView> isClaimedBySelf = wo -> wo.getClaimedBy().equals((Object)this.buildingView.getPosition());
        Predicate<IWorkOrderView> isUnclaimed = wo -> wo.getClaimedBy().equals((Object)BlockPos.ZERO);
        Predicate<IWorkOrderView> isInRange = wo -> wo.canBuildIgnoringDistance(this.buildingView.getPosition(), this.buildingView.getBuildingLevel());
        Predicate<IWorkOrderView> finalPredicate = shouldShow.and(isInRange);
        finalPredicate = this.manualMode ? finalPredicate.and(isClaimedBySelf).or(isUnclaimed) : finalPredicate.and(isClaimedBySelf);
        this.workOrders.clear();
        this.workOrders.addAll(this.buildingView.getColony().getWorkOrders().stream().filter(finalPredicate).toList());
        this.sortWorkOrders();
    }

    private void sortWorkOrders() {
        this.workOrders.sort(Comparator.comparing(IWorkOrder::getPriority, Comparator.reverseOrder()));
    }

    private void updateAvailableWorkOrders(int index, @NotNull Pane rowPane) {
        IWorkOrderView order = this.workOrders.get(index);
        boolean buttonEnabled = true;
        String disabledMessage = "";
        Text workOrderTextPanel = (Text)rowPane.findPaneOfTypeByID("buildingName", Text.class);
        ((AbstractTextBuilder.TooltipBuilder)PaneBuilders.tooltipBuilder().append(order.getDisplayName())).hoverPane((Pane)workOrderTextPanel).build();
        workOrderTextPanel.setText(order.getDisplayName());
        ((Text)rowPane.findPaneOfTypeByID("buildingPos", Text.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.blocks.distance", (Object[])new Object[]{BlockPosUtil.getDistance2D(order.getLocation(), this.buildingView.getPosition())}));
        if (this.buildingView.getAllAssignedCitizens().isEmpty()) {
            disabledMessage = "tile.blockhut.noworkerassigned";
            buttonEnabled = false;
        }
        if (!order.getClaimedBy().equals((Object)BlockPos.ZERO)) {
            disabledMessage = "tile.blockhut.alreadyclaimed";
            buttonEnabled = false;
        }
        if (!order.canBuildIgnoringDistance(this.buildingView.getPosition(), this.buildingView.getBuildingLevel())) {
            disabledMessage = "tile.blockhut.cannotbuild";
            buttonEnabled = false;
        }
        if (order.getClaimedBy().equals((Object)this.buildingView.getPosition())) {
            ((ButtonImage)rowPane.findPaneOfTypeByID("manage", ButtonImage.class)).setText(Component.translatableEscape((String)"com.minecolonies.coremod.gui.builder.cancel", (Object[])new Object[0]));
        } else if (this.manualMode) {
            Button assign = (Button)rowPane.findPaneOfTypeByID("manage", ButtonImage.class);
            assign.setText(Component.translatable((String)"com.minecolonies.coremod.gui.builder.select"));
            if (!buttonEnabled) {
                PaneBuilders.tooltipBuilder().hoverPane((Pane)assign).build().setText(Component.translatable((String)disabledMessage));
                assign.setEnabled(false);
            }
        }
    }

    private void selectWorkOrder(@NotNull Button button) {
        int row = this.workOrdersList.getListElementIndexByPane((Pane)button);
        IWorkOrderView view = this.workOrders.get(row);
        if (view.getClaimedBy().equals((Object)this.buildingView.getPosition())) {
            view.setClaimedBy(this.buildingView.getPosition());
            new WorkOrderChangeMessage(this.buildingView, view.getID(), true, 0).sendToServer();
        } else {
            new BuilderSelectWorkOrderMessage(this.buildingView, view.getID()).sendToServer();
        }
    }
}

