/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.ItemIcon;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.request.IRequest;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.modules.RequestTreeWindowModule;
import com.minecolonies.core.client.gui.modules.TabsWindowModule;
import com.minecolonies.core.colony.buildings.workerbuildings.PostBox;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.core.network.messages.server.colony.building.postbox.PostBoxRequestMessage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class WindowPostBoxMain
extends AbstractWindowSkeleton {
    private static final int TABS_X_OFFSET = 34;
    private static final String TAG_BUTTON_DELIVER_AVAILABLE = "deliverAvailable";
    private static final String RED_X = "\u00a7n\u00a74X";
    private static final String APPROVE = "\u2713";
    private final List<ItemStack> allItems = new ArrayList<ItemStack>();
    private final ScrollingList stackList;
    private final PostBox.View postBoxView;
    private final PostBoxRequestTreeWindowModule requestTreeWindowModule;
    private String filter = "";
    private boolean deliverAvailable;
    private int tick;

    public WindowPostBoxMain(PostBox.View postBoxView) {
        super(new ResourceLocation("minecolonies", "gui/windowpostboxrequest.xml"));
        this.postBoxView = postBoxView;
        this.requestTreeWindowModule = this.registerLayoutModule(PostBoxRequestTreeWindowModule::new, postBoxView, 261, 44);
        WindowPostBoxMain.registerPostboxTabs(this, postBoxView);
        this.registerButton("inventory", this::inventoryClicked);
        this.registerButton("request", this::requestClicked);
        this.registerButton(TAG_BUTTON_DELIVER_AVAILABLE, this::deliverPartialClicked);
        ((TextField)this.window.findPaneOfTypeByID("name", TextField.class)).setHandler(input -> {
            String newFilter = input.getText();
            if (!newFilter.equals(this.filter)) {
                this.filter = newFilter;
                this.tick = 10;
            }
        });
        this.stackList = (ScrollingList)this.findPaneOfTypeByID("resources", ScrollingList.class);
        this.stackList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return WindowPostBoxMain.this.allItems.size();
            }

            public boolean shouldUpdate() {
                return false;
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = WindowPostBoxMain.this.allItems.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                resourceLabel.setText(resource.getHoverName());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }

    private void inventoryClicked() {
        new OpenInventoryMessage(this.postBoxView).sendToServer();
    }

    private void requestClicked(Button button) {
        int row = this.stackList.getListElementIndexByPane((Pane)button);
        ItemStack stack = this.allItems.get(row);
        int qty = stack.getMaxStackSize();
        for (Pane child : button.getParent().getChildren()) {
            if (!child.getID().equals("qty")) continue;
            try {
                qty = Integer.parseInt(((TextField)child).getText());
            }
            catch (NumberFormatException numberFormatException) {}
        }
        new PostBoxRequestMessage(this.postBoxView, stack.copy(), qty, this.deliverAvailable).sendToServer();
        this.requestTreeWindowModule.refreshOpenRequests();
    }

    private void deliverPartialClicked(@NotNull Button button) {
        if (button.getTextAsString().equals(RED_X)) {
            button.setText(Component.literal((String)APPROVE));
            this.deliverAvailable = true;
        } else {
            button.setText(Component.literal((String)RED_X));
            this.deliverAvailable = false;
        }
    }

    public static void registerPostboxTabs(AbstractWindowSkeleton window, IBuildingView buildingView) {
        TabsWindowModule tabsWindowModule = window.registerModule(TabsWindowModule::new, new Random(buildingView.getID().hashCode()));
        tabsWindowModule.setTabXOffset(34);
        int nextTabIndex = 0;
        tabsWindowModule.renderTabButton(nextTabIndex++, TabsWindowModule.TabImageSide.LEFT, new ResourceLocation("minecolonies", "textures/gui/modules/main.png"), Component.translatable((String)"com.minecolonies.coremod.gui.maintab"), button -> buildingView.getWindow().open());
        List<IBuildingModuleView> allModuleViews = buildingView.getAllModuleViews();
        for (IBuildingModuleView view : allModuleViews) {
            if (!view.isPageVisible()) continue;
            tabsWindowModule.renderTabButton(nextTabIndex++, TabsWindowModule.TabImageSide.LEFT, view.getIconResourceLocation(), Optional.ofNullable(view.getDesc()).map(Component::copy).orElse(null), button -> {
                Minecraft.getInstance().getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
                view.getWindow().open();
            });
        }
    }

    @Override
    public void onOpened() {
        super.onOpened();
        ((Button)this.findPaneOfTypeByID(TAG_BUTTON_DELIVER_AVAILABLE, Button.class)).setText(Component.literal((String)RED_X));
        this.updateResources();
    }

    private void updateResources() {
        Predicate<ItemStack> filterPredicate = stack -> this.filter.isEmpty() || stack.getDescriptionId().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.getHoverName().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || stack.getItem() instanceof EnchantedBookItem && stack.getTagEnchantments().entrySet().stream().anyMatch(f -> ((Holder)f.getKey()).getRegisteredName().contains(this.filter.toLowerCase(Locale.US)));
        this.allItems.clear();
        this.allItems.addAll(this.getBlockList(filterPredicate));
        this.allItems.sort(Comparator.comparingInt(s1 -> StringUtils.getLevenshteinDistance((CharSequence)s1.getHoverName().getString(), (CharSequence)this.filter)));
        this.updateResourceList();
    }

    private Collection<? extends ItemStack> getBlockList(Predicate<ItemStack> filterPredicate) {
        Set<ItemStack> allItems = ItemStackUtils.allItemsPlusInventory((Player)Minecraft.getInstance().player);
        if (this.filter.isEmpty()) {
            return allItems;
        }
        return allItems.stream().filter(filterPredicate).collect(Collectors.toList());
    }

    private void updateResourceList() {
        this.stackList.enable();
        this.stackList.show();
        final ArrayList<ItemStack> tempRes = new ArrayList<ItemStack>(this.allItems);
        this.stackList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return tempRes.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ItemStack resource = (ItemStack)tempRes.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                resourceLabel.setText(resource.getHoverName());
                ((ItemIcon)rowPane.findPaneOfTypeByID("resourceIcon", ItemIcon.class)).setItem(resource);
            }
        });
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.updateResources();
        }
    }

    private static class PostBoxRequestTreeWindowModule
    extends RequestTreeWindowModule {
        @NotNull
        private final PostBox.View buildingView;

        private PostBoxRequestTreeWindowModule(AbstractWindowSkeleton parent, PostBox.View buildingView) {
            super(parent, buildingView.getColony());
            this.buildingView = buildingView;
        }

        @Override
        protected Collection<IRequest<?>> getOpenRequests() {
            return this.buildingView.getOpenRequestsOfBuilding();
        }

        @Override
        protected void onCancel(@NotNull IRequest<?> request) {
            this.buildingView.onRequestedRequestCancelled(this.buildingView.getColony().getRequestManager(), request);
        }
    }
}

