/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.IBuildingModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.client.gui.AbstractWindowSkeleton;
import com.minecolonies.core.client.gui.modules.TabsWindowModule;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;

public abstract class AbstractBuildingWindow<B extends IBuildingView>
extends AbstractWindowSkeleton {
    protected final B buildingView;

    public AbstractBuildingWindow(B buildingView, ResourceLocation resource) {
        this(null, buildingView, resource);
    }

    public AbstractBuildingWindow(BOWindow parent, B buildingView, ResourceLocation resource) {
        super(parent, resource);
        this.buildingView = buildingView;
        TabsWindowModule tabsWindowModule = this.registerModule(TabsWindowModule::new, new Random(buildingView.getID().hashCode()));
        if (this.shouldRenderDefaultSidebar()) {
            int nextTabIndex = 0;
            tabsWindowModule.renderTabButton(nextTabIndex++, TabsWindowModule.TabImageSide.LEFT, new ResourceLocation("minecolonies", "textures/gui/modules/main.png"), Component.translatable((String)"com.minecolonies.coremod.gui.maintab"), button -> buildingView.getWindow().open());
            List<IBuildingModuleView> allModuleViews = buildingView.getAllModuleViews();
            for (IBuildingModuleView view : allModuleViews) {
                if (!view.isPageVisible()) continue;
                tabsWindowModule.renderTabButton(nextTabIndex++, TabsWindowModule.TabImageSide.LEFT, view.getIconResourceLocation(), Optional.ofNullable(view.getDesc()).map(Component::copy).orElse(null), button -> {
                    this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
                    view.getWindow().open();
                });
            }
        }
    }

    protected boolean shouldRenderDefaultSidebar() {
        return true;
    }

    @Override
    public void setPage(boolean relative, int page) {
        super.setPage(relative, page);
        this.mc.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)SoundEvents.BOOK_PAGE_TURN, (float)1.0f));
    }
}

