/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlock;
import com.ldtteam.domumornamentum.block.IMateriallyTexturedBlockComponent;
import com.minecolonies.api.blocks.AbstractBlockMinecoloniesRack;
import com.minecolonies.api.blocks.types.RackType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.core.tileentities.TileEntityRack;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class BlockMinecoloniesRack
extends AbstractBlockMinecoloniesRack<BlockMinecoloniesRack>
implements IMateriallyTexturedBlock {
    private static final Long2ObjectMap<Direction> BY_NORMAL = (Long2ObjectMap)Arrays.stream(Direction.values()).collect(Collectors.toMap(p_235679_ -> new BlockPos(p_235679_.getNormal()).asLong(), p_235675_ -> p_235675_, (p_235670_, p_235671_) -> {
        throw new IllegalArgumentException("Duplicate keys");
    }, Long2ObjectOpenHashMap::new));
    private static final float BLOCK_HARDNESS = 10.0f;
    private static final String BLOCK_NAME = "blockminecoloniesrack";
    private static final float RESISTANCE = Float.POSITIVE_INFINITY;
    private static final VoxelShape SHAPE = Shapes.box((double)0.1, (double)0.1, (double)0.1, (double)0.9, (double)0.9, (double)0.9);

    public BlockMinecoloniesRack() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(10.0f, Float.POSITIVE_INFINITY));
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)VARIANT, (Comparable)((Object)RackType.EMPTY)));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", BLOCK_NAME);
    }

    public boolean propagatesSkylightDown(BlockState state, @NotNull BlockGetter reader, @NotNull BlockPos pos) {
        return true;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext ctx) {
        return Shapes.block();
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        if (context.getPlayer() != null) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getPlayer().getDirection().getOpposite());
        }
        return super.getStateForPlacement(context);
    }

    @Deprecated
    @NotNull
    public BlockState rotate(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @Deprecated
    @NotNull
    public BlockState mirror(@NotNull BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState state, @NotNull Direction dir, BlockState neighbourState, @NotNull LevelAccessor level, @NotNull BlockPos pos, @NotNull BlockPos neighbourPos) {
        if (state.getBlock() != this || pos.subtract((Vec3i)neighbourPos).getY() != 0) {
            return super.updateShape(state, dir, neighbourState, level, pos, neighbourPos);
        }
        BlockEntity here = level.getBlockEntity(pos);
        if (!(here instanceof TileEntityRack)) {
            return super.updateShape(state, dir, neighbourState, level, pos, neighbourPos);
        }
        TileEntityRack hereRack = (TileEntityRack)here;
        if (neighbourState.getBlock() != this) {
            if (((RackType)((Object)state.getValue((Property)VARIANT))).isDoubleVariant() && pos.relative((Direction)state.getValue((Property)FACING)).equals((Object)neighbourPos)) {
                return (BlockState)state.setValue((Property)VARIANT, (Comparable)((Object)(hereRack.isEmpty() ? RackType.EMPTY : RackType.FULL)));
            }
            return super.updateShape(state, dir, neighbourState, level, pos, neighbourPos);
        }
        if (!((RackType)((Object)state.getValue((Property)VARIANT))).isDoubleVariant() && !((RackType)((Object)neighbourState.getValue((Property)VARIANT))).isDoubleVariant()) {
            BlockEntity neighbour = level.getBlockEntity(neighbourPos);
            if (!(neighbour instanceof TileEntityRack)) {
                return super.updateShape(state, dir, neighbourState, level, pos, neighbourPos);
            }
            TileEntityRack neighborRack = (TileEntityRack)neighbour;
            boolean isEmpty = hereRack.isEmpty() && neighborRack.isEmpty();
            level.setBlock(neighbourPos, (BlockState)((BlockState)neighbourState.setValue((Property)FACING, (Comparable)((Direction)BY_NORMAL.get(neighbourPos.subtract((Vec3i)pos).asLong())).getOpposite())).setValue((Property)VARIANT, (Comparable)((Object)RackType.NO_RENDER)), 1);
            return (BlockState)((BlockState)state.setValue((Property)VARIANT, (Comparable)((Object)(isEmpty ? RackType.EMPTY_DOUBLE : RackType.FULL_DOUBLE)))).setValue((Property)FACING, (Comparable)((Direction)BY_NORMAL.get(neighbourPos.subtract((Vec3i)pos).asLong())));
        }
        if (((RackType)((Object)state.getValue((Property)VARIANT))).isDoubleVariant() && pos.relative((Direction)state.getValue((Property)FACING)).equals((Object)neighbourPos)) {
            if (!((Direction)neighbourState.getValue((Property)FACING)).equals((Object)((Direction)state.getValue((Property)FACING)).getOpposite()) || !((RackType)((Object)neighbourState.getValue((Property)VARIANT))).isDoubleVariant()) {
                return (BlockState)state.setValue((Property)VARIANT, (Comparable)((Object)(hereRack.isEmpty() ? RackType.EMPTY : RackType.FULL)));
            }
            if (neighbourState.getValue((Property)VARIANT) != RackType.NO_RENDER && state.getValue((Property)VARIANT) != RackType.NO_RENDER) {
                return (BlockState)state.setValue((Property)VARIANT, (Comparable)((Object)RackType.NO_RENDER));
            }
        }
        return super.updateShape(state, dir, neighbourState, level, pos, neighbourPos);
    }

    public ItemInteractionResult useItemOn(ItemStack p_316304_, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos);
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if ((colony == null || colony.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) && tileEntity instanceof TileEntityRack) {
            TileEntityRack rack = (TileEntityRack)tileEntity;
            if (!worldIn.isClientSide) {
                ((ServerPlayer)player).openMenu((MenuProvider)rack, buf -> buf.writeBlockPos(rack.getBlockPos()).writeBlockPos(rack.getOtherChest() == null ? BlockPos.ZERO : rack.getOtherChest().getBlockPos()));
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.FAIL;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, VARIANT});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityRack(blockPos, blockState);
    }

    public List<ItemStack> getDrops(BlockState state, LootParams.Builder builder) {
        ArrayList<ItemStack> drops = new ArrayList<ItemStack>();
        drops.add(new ItemStack((ItemLike)this, 1));
        return drops;
    }

    public void onRemove(BlockState state, @NotNull Level worldIn, @NotNull BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.getBlock() != newState.getBlock()) {
            BlockEntity tileEntity = worldIn.getBlockEntity(pos);
            if (tileEntity instanceof TileEntityRack) {
                TileEntityRack tileEntityRack = (TileEntityRack)tileEntity;
                InventoryUtils.dropItemHandler((IItemHandler)tileEntityRack.getInventory(), worldIn, tileEntityRack.getBlockPos().getX(), tileEntityRack.getBlockPos().getY(), tileEntityRack.getBlockPos().getZ());
                worldIn.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, worldIn, pos, newState, isMoving);
        }
    }

    @NotNull
    public Collection<IMateriallyTexturedBlockComponent> getComponents() {
        return Collections.emptyList();
    }

    public void buildRecipes(RecipeOutput recipeOutput) {
    }
}

