/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.minecolonies.api.blocks.AbstractBlockMinecoloniesNamedGrave;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.core.tileentities.TileEntityNamedGrave;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockMinecoloniesNamedGrave
extends AbstractBlockMinecoloniesNamedGrave<BlockMinecoloniesNamedGrave> {
    private static final float BLOCK_HARDNESS = 5.0f;
    private static final String BLOCK_NAME = "blockminecoloniesnamedgrave";
    private static final float RESISTANCE = 1.0f;

    public BlockMinecoloniesNamedGrave() {
        super(BlockBehaviour.Properties.of().mapColor(MapColor.STONE).sound(SoundType.STONE).strength(5.0f, 1.0f).noLootTable());
        BlockState bs = this.defaultBlockState();
        this.registerDefaultState((BlockState)bs.setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", BLOCK_NAME);
    }

    public void setPlacedBy(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockState tempState = state;
        if (placer != null) {
            tempState = (BlockState)tempState.setValue((Property)FACING, (Comparable)placer.getDirection().getOpposite());
        }
        worldIn.setBlock(pos, tempState, 2);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityNamedGrave(blockPos, blockState);
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.1, (double)1.0);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Level worldIn = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockState state = this.defaultBlockState();
        BlockEntity entity = worldIn.getBlockEntity(pos);
        if (!(entity instanceof TileEntityNamedGrave)) {
            return super.getStateForPlacement(context);
        }
        return BlockMinecoloniesNamedGrave.getPlacementState(state, entity, pos);
    }

    public static BlockState getPlacementState(BlockState state, BlockEntity entity, BlockPos pos) {
        return state;
    }

    @Deprecated
    @NotNull
    public BlockState rotate(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)AbstractBlockMinecoloniesNamedGrave.FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)AbstractBlockMinecoloniesNamedGrave.FACING)));
    }

    @Deprecated
    @NotNull
    public BlockState mirror(@NotNull BlockState state, Mirror mirrorIn) {
        return state.rotate(mirrorIn.getRotation((Direction)state.getValue((Property)AbstractBlockMinecoloniesNamedGrave.FACING)));
    }

    public boolean canSurvive(BlockState state, LevelReader worldIn, BlockPos pos) {
        return !worldIn.isEmptyBlock(pos.below()) && worldIn.getBlockState(pos.below()).getBlock() != ModBlocks.blockNamedGrave;
    }
}

