/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.blocks;

import com.ldtteam.structurize.blocks.interfaces.IAnchorBlock;
import com.ldtteam.structurize.blocks.interfaces.ILeveledBlueprintAnchorBlock;
import com.minecolonies.api.blocks.AbstractBlockMinecoloniesDirectional;
import com.minecolonies.api.blocks.decorative.AbstractBlockMinecoloniesConstructionTape;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.entity.ai.workers.util.IBuilderUndestroyable;
import com.minecolonies.core.client.gui.WindowDecorationController;
import com.minecolonies.core.tileentities.TileEntityDecorationController;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class BlockDecorationController
extends AbstractBlockMinecoloniesDirectional<BlockDecorationController>
implements IBuilderUndestroyable,
IAnchorBlock,
EntityBlock,
ILeveledBlueprintAnchorBlock,
SimpleWaterloggedBlock {
    public static final MapCodec<BlockDecorationController> CODEC = BlockDecorationController.simpleCodec(BlockDecorationController::new);
    private static final float BLOCK_HARDNESS = 5.0f;
    private static final String BLOCK_NAME = "decorationcontroller";
    private static final float RESISTANCE = 1.0f;
    public static BooleanProperty MIRROR = BooleanProperty.create((String)"mirror");
    protected static final VoxelShape AABB_SOUTH = Shapes.box((double)0.25, (double)0.314, (double)0.7, (double)0.75, (double)0.86, (double)1.0);
    protected static final VoxelShape AABB_NORTH = Shapes.box((double)0.25, (double)0.314, (double)0.0, (double)0.75, (double)0.86, (double)0.3);
    protected static final VoxelShape AABB_EAST = Shapes.box((double)0.7, (double)0.314, (double)0.25, (double)1.0, (double)0.86, (double)0.75);
    protected static final VoxelShape AABB_WEST = Shapes.box((double)0.0, (double)0.314, (double)0.25, (double)0.3, (double)0.86, (double)0.75);
    protected static final VoxelShape AABB_UP = Shapes.box((double)0.25, (double)0.7, (double)0.14, (double)0.75, (double)1.0, (double)0.686);
    protected static final VoxelShape AABB_DOWN = Shapes.box((double)0.25, (double)0.0, (double)0.314, (double)0.75, (double)0.3, (double)0.86);

    public BlockDecorationController() {
        this(BlockBehaviour.Properties.of().mapColor(MapColor.WOOD).sound(SoundType.WOOD).strength(5.0f, 1.0f).noCollission());
    }

    public BlockDecorationController(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)MIRROR, (Comparable)Boolean.valueOf(false))).setValue((Property)AbstractBlockMinecoloniesConstructionTape.WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected MapCodec<BlockDecorationController> codec() {
        return CODEC;
    }

    @Override
    public ResourceLocation getRegistryName() {
        return new ResourceLocation("minecolonies", BLOCK_NAME);
    }

    public VoxelShape getShape(BlockState decoController, BlockGetter level, BlockPos pos, CollisionContext context) {
        VoxelShape shape;
        Direction direction = (Direction)decoController.getValue((Property)FACING);
        BlockPos offsetPos = pos.relative(direction);
        BlockState state = level.getBlockState(offsetPos);
        VoxelShape voxelShape = shape = state.getBlock() != this ? state.getShape(level, offsetPos) : Shapes.block();
        if (shape.isEmpty() || Block.isShapeFullBlock((VoxelShape)shape)) {
            return switch (direction) {
                default -> throw new MatchException(null, null);
                case Direction.EAST -> AABB_EAST;
                case Direction.WEST -> AABB_WEST;
                case Direction.SOUTH -> AABB_SOUTH;
                case Direction.NORTH -> AABB_NORTH;
                case Direction.UP -> AABB_UP;
                case Direction.DOWN -> AABB_DOWN;
            };
        }
        return switch (direction) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> AABB_UP.move(0.0, shape.min(Direction.Axis.Y), 0.0);
            case Direction.DOWN -> AABB_DOWN.move(0.0, shape.max(Direction.Axis.Y) - 1.0, 0.0);
            case Direction.NORTH -> AABB_NORTH.move(0.0, 0.0, shape.max(Direction.Axis.Z) - 1.0);
            case Direction.SOUTH -> AABB_SOUTH.move(0.0, 0.0, shape.min(Direction.Axis.Z));
            case Direction.EAST -> AABB_EAST.move(shape.min(Direction.Axis.X), 0.0, 0.0);
            case Direction.WEST -> AABB_WEST.move(shape.max(Direction.Axis.X) - 1.0, 0.0, 0.0);
        };
    }

    @NotNull
    public BlockState updateShape(@NotNull BlockState stateIn, Direction dir, BlockState state, LevelAccessor worldIn, @NotNull BlockPos currentPos, BlockPos pos) {
        if (((Boolean)stateIn.getValue((Property)AbstractBlockMinecoloniesConstructionTape.WATERLOGGED)).booleanValue()) {
            worldIn.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)worldIn));
        }
        return super.updateShape(stateIn, dir, state, worldIn, currentPos, pos);
    }

    public ItemInteractionResult useItemOn(ItemStack Stack2, BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        BlockEntity tileEntity;
        if (worldIn.isClientSide && (tileEntity = worldIn.getBlockEntity(pos)) instanceof TileEntityDecorationController) {
            new WindowDecorationController(pos).open();
        }
        return ItemInteractionResult.SUCCESS;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.INVISIBLE;
    }

    public void setPlacedBy(@NotNull Level worldIn, @NotNull BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        IColony colony;
        super.setPlacedBy(worldIn, pos, state, placer, stack);
        if (worldIn.isClientSide) {
            return;
        }
        BlockEntity tileEntity = worldIn.getBlockEntity(pos);
        if (tileEntity instanceof TileEntityDecorationController && ((List)((TileEntityDecorationController)tileEntity).getPositionedTags().getOrDefault(BlockPos.ZERO, new ArrayList())).contains("leisure") && (colony = IColonyManager.getInstance().getColonyByPosFromWorld(worldIn, pos)) != null) {
            colony.getBuildingManager().addLeisureSite(pos);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, MIRROR, AbstractBlockMinecoloniesConstructionTape.WATERLOGGED});
    }

    @Nullable
    public BlockEntity newBlockEntity(@NotNull BlockPos blockPos, @NotNull BlockState blockState) {
        return new TileEntityDecorationController(blockPos, blockState);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Fluid fluid = context.getLevel().getFluidState(context.getClickedPos()).getType();
        return (BlockState)((BlockState)super.getStateForPlacement(context).setValue((Property)FACING, (Comparable)context.getClickedFace().getOpposite())).setValue((Property)AbstractBlockMinecoloniesConstructionTape.WATERLOGGED, (Comparable)Boolean.valueOf(fluid == Fluids.WATER));
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)AbstractBlockMinecoloniesConstructionTape.WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, Rotation rot) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rot.rotate((Direction)state.getValue((Property)FACING)));
    }

    @NotNull
    public BlockState mirror(@NotNull BlockState state, Mirror mirrorIn) {
        return (BlockState)state.setValue((Property)MIRROR, (Comparable)Boolean.valueOf(mirrorIn != Mirror.NONE));
    }

    public int getLevel(CompoundTag beData) {
        if (beData == null) {
            return 0;
        }
        try {
            return Integer.parseInt(beData.getCompound("blueprintDataProvider").getString("schematicName").replaceAll("[^0-9]", ""));
        }
        catch (NumberFormatException exception) {
            return 0;
        }
    }
}

