/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.minecolonies.api.util.constant.ColonyConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Pond {
    public static final int WATER_POOL_WIDTH_REQUIREMENT = 5;
    public static final int WATER_DEPTH_REQUIREMENT = 2;

    public static PondState checkPond(@NotNull BlockGetter world, @NotNull BlockPos water, @Nullable BlockPos.MutableBlockPos problematicPosition) {
        PondState worstPondState = PondState.VALID;
        block0: for (BlockPos.MutableBlockPos tempPos : BlockPos.spiralAround((BlockPos)water, (int)2, (Direction)Direction.SOUTH, (Direction)Direction.EAST)) {
            PondState pondState = PondState.VALID;
            for (int y = 0; y < 2; ++y) {
                pondState = Pond.checkWaterForFishing(world, (BlockPos)tempPos.setY(tempPos.getY() - y));
                if (pondState == PondState.INVALID) {
                    if (problematicPosition != null) {
                        problematicPosition.set((Vec3i)tempPos);
                    }
                    return PondState.INVALID;
                }
                if (pondState == PondState.SUBOPTIMAL) {
                    worstPondState = PondState.SUBOPTIMAL;
                }
                if (ColonyConstants.rand.nextInt(100) < 30) continue block0;
            }
        }
        return worstPondState;
    }

    public static PondState checkWaterForFishing(BlockGetter world, BlockPos pos) {
        FluidState fluidstate;
        PondState pondState = PondState.INVALID;
        BlockState state = world.getBlockState(pos);
        if (!state.isAir() && !state.is(Blocks.LILY_PAD) && (fluidstate = state.getFluidState()).is(FluidTags.WATER) && state.getCollisionShape(world, pos).isEmpty()) {
            pondState = fluidstate.isSource() ? PondState.VALID : PondState.SUBOPTIMAL;
        }
        return pondState;
    }

    public static enum PondState {
        INVALID,
        SUBOPTIMAL,
        VALID;

    }
}

