/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;

@FunctionalInterface
public interface IItemHandlerCapProvider {
    @Nullable
    default public IItemHandler getItemHandlerCap(Void nothing) {
        return this.getItemHandlerCap();
    }

    @Nullable
    default public IItemHandler getItemHandlerCap() {
        return this.getItemHandlerCap((Direction)null);
    }

    @Nullable
    public IItemHandler getItemHandlerCap(Direction var1);

    public static IItemHandlerCapProvider wrap(BlockEntity blockEntity) {
        return direction -> (IItemHandler)Capabilities.ItemHandler.BLOCK.getCapability(blockEntity.getLevel(), blockEntity.getBlockPos(), blockEntity.getBlockState(), blockEntity, (Object)direction);
    }

    public static IItemHandlerCapProvider wrap(Entity entity, boolean sided) {
        return sided ? direction -> (IItemHandler)Capabilities.ItemHandler.ENTITY_AUTOMATION.getCapability(entity, (Object)direction) : direction -> (IItemHandler)Capabilities.ItemHandler.ENTITY.getCapability(entity, null);
    }

    public static IItemHandlerCapProvider wrap(ItemStack itemStack) {
        return direction -> (IItemHandler)Capabilities.ItemHandler.ITEM.getCapability(itemStack, null);
    }
}

