/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.ldtteam.structurize.api.Log;
import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.blockentities.interfaces.IBlueprintDataProviderBE;
import com.ldtteam.structurize.blueprints.v1.Blueprint;
import com.ldtteam.structurize.management.Manager;
import com.ldtteam.structurize.operations.PlaceStructureOperation;
import com.ldtteam.structurize.placement.StructurePlacer;
import com.ldtteam.structurize.placement.structure.CreativeStructureHandler;
import com.ldtteam.structurize.placement.structure.IStructureHandler;
import com.ldtteam.structurize.storage.StructurePacks;
import com.ldtteam.structurize.util.ITickedWorldOperation;
import com.minecolonies.api.blocks.ModBlocks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.entity.ai.workers.util.ConstructionTapeHelper;
import java.util.List;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CreativeBuildingStructureHandler
extends CreativeStructureHandler {
    private IBuilding building;

    public CreativeBuildingStructureHandler(Level world, BlockPos pos, Blueprint blueprint, RotationMirror rotMir, boolean fancyPlacement) {
        super(world, pos, blueprint, rotMir, fancyPlacement);
        this.setupBuilding();
    }

    public CreativeBuildingStructureHandler(Level world, BlockPos pos, Future<Blueprint> blueprint, RotationMirror rotMir, boolean fancyPlacement) {
        super(world, pos, blueprint, rotMir, fancyPlacement);
        this.setupBuilding();
    }

    private void setupBuilding() {
        IColony colony = IColonyManager.getInstance().getColonyByPosFromWorld(this.getWorld(), this.getWorldPos());
        if (colony != null) {
            this.building = colony.getBuildingManager().getBuilding(this.getWorldPos());
        }
    }

    public void triggerSuccess(BlockPos pos, List<ItemStack> list, boolean placement) {
        BlockEntity te;
        super.triggerSuccess(pos, list, placement);
        BlockPos worldPos = this.getProgressPosInWorld(pos);
        Blueprint blueprint = this.getBluePrint();
        CompoundTag teData = blueprint.getTileEntityData(worldPos, pos);
        if (teData != null && teData.contains("blueprintDataProvider") && (te = this.getWorld().getBlockEntity(worldPos)) instanceof IBlueprintDataProviderBE) {
            AbstractTileEntityColonyBuilding colonyBuilding;
            IBlueprintDataProviderBE blueprintDataProviderBE = (IBlueprintDataProviderBE)te;
            CompoundTag tagData = teData.getCompound("blueprintDataProvider");
            String schematicPath = tagData.getString("name");
            String location = StructurePacks.getStructurePack((String)blueprint.getPackName()).getSubPath(Utils.resolvePath(blueprint.getFilePath(), schematicPath));
            tagData.putString("name", location);
            tagData.putString("pack", blueprint.getPackName());
            if (te instanceof AbstractTileEntityColonyBuilding && (colonyBuilding = (AbstractTileEntityColonyBuilding)te).getBuilding() != null) {
                colonyBuilding.getBuilding().setDeconstructed();
            }
            blueprintDataProviderBE.readSchematicDataFromNBT(teData);
            ((ServerLevel)this.getWorld()).getChunkSource().blockChanged(worldPos);
            te.setChanged();
        }
        if (this.building != null) {
            this.building.registerBlockPosition(blueprint.getBlockState(pos), worldPos, this.getWorld());
        }
    }

    public boolean shouldBlocksBeConsideredEqual(BlockState state1, BlockState state2) {
        Block block1 = state1.getBlock();
        Block block2 = state2.getBlock();
        if (block1 == Blocks.FLOWER_POT || block2 == Blocks.FLOWER_POT) {
            return block1 == block2;
        }
        if (block1 == Blocks.GRASS_BLOCK && block2 == Blocks.DIRT || block2 == Blocks.GRASS_BLOCK && block1 == Blocks.DIRT) {
            return true;
        }
        return super.shouldBlocksBeConsideredEqual(state1, state2);
    }

    public boolean isStackFree(@Nullable ItemStack itemStack) {
        return itemStack == null || itemStack.isEmpty() || itemStack.is(ItemTags.LEAVES) || itemStack.getItem() == new ItemStack(ModBlocks.blockDecorationPlaceholder, 1).getItem();
    }

    public static Blueprint loadAndPlaceStructureWithRotation(Level worldObj, @NotNull Future<Blueprint> future, @NotNull BlockPos pos, RotationMirror rotMir, boolean fancyPlacement, @Nullable ServerPlayer player) {
        try {
            @NotNull CreativeBuildingStructureHandler structure = new CreativeBuildingStructureHandler(worldObj, pos, future, rotMir, fancyPlacement);
            if (structure.hasBluePrint()) {
                @NotNull StructurePlacer instantPlacer = new StructurePlacer((IStructureHandler)structure);
                Manager.addToQueue((ITickedWorldOperation)new PlaceStructureOperation(instantPlacer, (Player)player));
            }
            return structure.getBluePrint();
        }
        catch (IllegalStateException e) {
            Log.getLogger().warn("Could not load structure!", (Throwable)e);
            return null;
        }
    }

    public void onCompletion() {
        super.onCompletion();
        if (this.building != null) {
            ConstructionTapeHelper.removeConstructionTape(this.building.getCorners(), this.getWorld());
        }
    }
}

