/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.util;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.util.EntityUtils;
import com.minecolonies.api.util.WorldUtil;
import com.minecolonies.api.util.constant.ColonyConstants;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.AirBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BlockPosUtil {
    private static final int MAX_DEPTH = 50;
    private static final int BLOCKPOS_LENGTH = 3;
    public static final List<Direction> HORIZONTAL_DIRS = Arrays.asList(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST);
    public static final BlockPos SAFE_ZERO = BlockPos.ZERO.below(4096);
    public static final BiPredicate<BlockGetter, BlockPos> SOLID_AIR_POS_SELECTOR = (world, pos) -> (world.getBlockState(pos).isSolid() || world.getBlockState(pos).liquid()) && world.getBlockState(pos.above()).isAir() && world.getBlockState(pos.above(2)).isAir();
    public static final BiPredicate<BlockGetter, BlockPos> DOUBLE_AIR_POS_SELECTOR = (world, pos) -> world.getBlockState(pos).isAir() && world.getBlockState(pos.above(1)).isAir();

    private BlockPosUtil() {
    }

    public static CompoundTag write(@NotNull CompoundTag compound, String name, @NotNull BlockPos pos) {
        @NotNull CompoundTag coordsCompound = new CompoundTag();
        coordsCompound.putInt("x", pos.getX());
        coordsCompound.putInt("y", pos.getY());
        coordsCompound.putInt("z", pos.getZ());
        compound.put(name, (Tag)coordsCompound);
        return compound;
    }

    @NotNull
    public static CompoundTag writeOptional(@NotNull CompoundTag compound, @NotNull String name, @Nullable BlockPos value) {
        if (value != null) {
            BlockPosUtil.write(compound, name, value);
        }
        return compound;
    }

    public static BlockPos getRandomPosAround(BlockPos center, int distance) {
        Vec3 vec = new Vec3(ColonyConstants.rand.nextDouble() - 0.5, ColonyConstants.rand.nextDouble() - 0.5, ColonyConstants.rand.nextDouble() - 0.5).normalize().multiply((double)distance, (double)distance, (double)distance);
        return new BlockPos((int)Math.round((double)center.getX() + vec.x), (int)Math.round((double)center.getY() + vec.y), (int)Math.round((double)center.getZ() + vec.z));
    }

    public static BlockPos getRandomPosition(Level world, BlockPos currentPosition, BlockPos def, int minDist, int maxDist) {
        return BlockPosUtil.getRandomPosition(world, currentPosition, def, minDist, maxDist, false);
    }

    public static BlockPos getRandomPosition(Level world, BlockPos currentPosition, BlockPos def, int minDist, int maxDist, boolean load) {
        int tries = 0;
        BlockPos pos = null;
        while (pos == null || !load && !WorldUtil.isEntityBlockLoaded((LevelAccessor)world, pos) || world.getBlockState(pos).liquid() || !BlockUtils.isAnySolid((BlockState)world.getBlockState(pos.below())) || !world.isEmptyBlock(pos) || !world.isEmptyBlock(pos.above())) {
            pos = BlockPosUtil.getRandomPosAround(currentPosition, ColonyConstants.rand.nextInt(maxDist) + minDist).above(ColonyConstants.rand.nextInt(3)).below(ColonyConstants.rand.nextInt(3));
            if (tries >= 20) {
                return def;
            }
            ++tries;
        }
        return pos;
    }

    @NotNull
    public static BlockPos read(@NotNull CompoundTag compound, String name) {
        CompoundTag coordsCompound = compound.getCompound(name);
        int x = coordsCompound.getInt("x");
        int y = coordsCompound.getInt("y");
        int z = coordsCompound.getInt("z");
        return new BlockPos(x, y, z);
    }

    @Nullable
    public static BlockPos readOrNull(@NotNull CompoundTag compound, @NotNull String name) {
        BlockPos result = BlockPosUtil.read(compound, name);
        return result.equals((Object)BlockPos.ZERO) ? null : result;
    }

    public static void writeToListNBT(@NotNull ListTag tagList, @NotNull BlockPos pos) {
        @NotNull CompoundTag coordsCompound = new CompoundTag();
        coordsCompound.putInt("x", pos.getX());
        coordsCompound.putInt("y", pos.getY());
        coordsCompound.putInt("z", pos.getZ());
        tagList.add((Object)coordsCompound);
    }

    public static void writePosListToNBT(CompoundTag compoundNBT, String tagname, List<BlockPos> positions) {
        ListTag listNBT = new ListTag();
        for (BlockPos pos : positions) {
            BlockPosUtil.writeToListNBT(listNBT, pos);
        }
        compoundNBT.put(tagname, (Tag)listNBT);
    }

    public static List<BlockPos> readPosListFromNBT(CompoundTag compoundNBT, String tagname) {
        ArrayList<BlockPos> result = new ArrayList<BlockPos>();
        ListTag listNBT = compoundNBT.getList(tagname, 10);
        for (int i = 0; i < listNBT.size(); ++i) {
            result.add(BlockPosUtil.readFromListNBT(listNBT, i));
        }
        return result;
    }

    @NotNull
    public static BlockPos readFromListNBT(@NotNull ListTag tagList, int index) {
        CompoundTag coordsCompound = tagList.getCompound(index);
        int x = coordsCompound.getInt("x");
        int y = coordsCompound.getInt("y");
        int z = coordsCompound.getInt("z");
        return new BlockPos(x, y, z);
    }

    @Nullable
    public static BlockPos getBlockPosOfString(@NotNull String inputText) {
        String[] strings = inputText.split(" ");
        if (strings.length == 3) {
            try {
                int x = Integer.parseInt(strings[0]);
                int y = Integer.parseInt(strings[1]);
                int z = Integer.parseInt(strings[2]);
                return new BlockPos(x, y, z);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @NotNull
    public static String getString(@NotNull BlockPos position) {
        return "{x=" + position.getX() + ", y=" + position.getY() + ", z=" + position.getZ() + "}";
    }

    public static BlockPos findLand(BlockPos blockPos, Level world) {
        int top = blockPos.getY();
        int bot = 0;
        int mid = blockPos.getY();
        BlockPos foundland = null;
        BlockPos tempPos = blockPos;
        while (top >= bot) {
            Block block = world.getBlockState(tempPos = new BlockPos(tempPos.getX(), mid, tempPos.getZ())).getBlock();
            if (block instanceof AirBlock && world.canSeeSkyFromBelowWater(tempPos)) {
                top = mid - 1;
                foundland = tempPos;
            } else {
                bot = mid + 1;
                foundland = tempPos;
            }
            mid = (bot + top) / 2;
        }
        if (BlockUtils.isAnySolid((BlockState)world.getBlockState(tempPos))) {
            return foundland.above();
        }
        return foundland;
    }

    public static double getValidHeight(@NotNull Vec3 position, @NotNull Level world) {
        double returnHeight = position.y;
        if (position.y < (double)world.getMinBuildHeight()) {
            returnHeight = world.getMinBuildHeight();
        }
        while (returnHeight >= 1.0 && world.isEmptyBlock(new BlockPos(Mth.floor((double)position.x), (int)returnHeight, Mth.floor((double)position.z)))) {
            returnHeight -= 1.0;
        }
        while (!world.isEmptyBlock(new BlockPos(Mth.floor((double)position.x), (int)returnHeight, Mth.floor((double)position.z)))) {
            returnHeight += 1.0;
        }
        return returnHeight;
    }

    public static long getDistanceSquared(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long zDiff;
        long yDiff;
        long xDiff = (long)block1.getX() - (long)block2.getX();
        long result = xDiff * xDiff + (yDiff = (long)block1.getY() - (long)block2.getY()) * yDiff + (zDiff = (long)block1.getZ() - (long)block2.getZ()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + yDiff + " | " + zDiff);
        }
        return result;
    }

    public static long getDistance2D(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long xDiff = Math.abs((long)block1.getX() - (long)block2.getX());
        long zDiff = Math.abs((long)block1.getZ() - (long)block2.getZ());
        return Math.abs(xDiff + zDiff);
    }

    public static int getMaxDistance2D(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        int xDif = Math.abs(block1.getX() - block2.getX());
        int zDif = Math.abs(block1.getZ() - block2.getZ());
        return Math.max(xDif, zDif);
    }

    public static double getDistance(BlockPos pos1, BlockPos pos2) {
        long xDiff = pos1.getX() - pos2.getX();
        long yDiff = pos1.getY() - pos2.getY();
        long zDiff = pos1.getZ() - pos2.getZ();
        return Math.sqrt(xDiff * xDiff + yDiff * yDiff + zDiff * zDiff);
    }

    public static long getDistanceSquared2D(@NotNull BlockPos block1, @NotNull BlockPos block2) {
        long zDiff;
        long xDiff = (long)block1.getX() - (long)block2.getX();
        long result = xDiff * xDiff + (zDiff = (long)block1.getZ() - (long)block2.getZ()) * zDiff;
        if (result < 0L) {
            throw new IllegalStateException("max-sqrt is to high! Failure to catch overflow with " + xDiff + " | " + zDiff);
        }
        return result;
    }

    public static int distManhattan(BlockPos pos, BlockPos pos2) {
        int xDist = Math.abs(pos.getX() - pos2.getX());
        int yDist = Math.abs(pos.getY() - pos2.getY());
        int zDist = Math.abs(pos.getZ() - pos2.getZ());
        return xDist + yDist + zDist;
    }

    public static int distManhattan(BlockPos pos, int x2, int y2, int z2) {
        int xDist = Math.abs(pos.getX() - x2);
        int yDist = Math.abs(pos.getY() - y2);
        int zDist = Math.abs(pos.getZ() - z2);
        return xDist + yDist + zDist;
    }

    public static int distManhattan(int x1, int y1, int z1, int x2, int y2, int z2) {
        int xDist = Math.abs(x1 - x2);
        int yDist = Math.abs(y1 - y2);
        int zDist = Math.abs(z1 - z2);
        return xDist + yDist + zDist;
    }

    public static int distSqr(BlockPos pos, BlockPos pos2) {
        int xDist = pos.getX() - pos2.getX();
        int yDist = pos.getY() - pos2.getY();
        int zDist = pos.getZ() - pos2.getZ();
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }

    public static int distSqr(BlockPos pos, int x2, int y2, int z2) {
        int xDist = pos.getX() - x2;
        int yDist = pos.getY() - y2;
        int zDist = pos.getZ() - z2;
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }

    public static int distSqr(int x1, int y1, int z1, int x2, int y2, int z2) {
        int xDist = x1 - x2;
        int yDist = y1 - y2;
        int zDist = z1 - z2;
        return xDist * xDist + yDist * yDist + zDist * zDist;
    }

    public static double dist(BlockPos pos, int x2, int y2, int z2) {
        int xDist = pos.getX() - x2;
        int yDist = pos.getY() - y2;
        int zDist = pos.getZ() - z2;
        return Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist);
    }

    public static double dist(BlockPos pos, BlockPos pos2) {
        int xDist = pos.getX() - pos2.getX();
        int yDist = pos.getY() - pos2.getY();
        int zDist = pos.getZ() - pos2.getZ();
        return Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist);
    }

    public static double dist(int x1, int y1, int z1, int x2, int y2, int z2) {
        int xDist = x1 - x2;
        int yDist = y1 - y2;
        int zDist = z1 - z2;
        return Math.sqrt(xDist * xDist + yDist * yDist + zDist * zDist);
    }

    public static BoundingBox getChunkAlignedBB(BlockPos pos, int chunkRadius) {
        int blockRadius = chunkRadius * 16;
        int x1 = pos.getX() & 0xFFFFFFF0;
        int y1 = pos.getY() & 0xFFFFFFF0;
        int z1 = pos.getZ() & 0xFFFFFFF0;
        return new BoundingBox(x1 - blockRadius, y1 - blockRadius, z1 - blockRadius, x1 + blockRadius + 15, y1 + blockRadius + 15, z1 + blockRadius + 15);
    }

    public static BlockEntity getTileEntity(@NotNull Level world, @NotNull BlockPos pos) {
        return world.getBlockEntity(pos);
    }

    public static List<ItemStack> getBlockDrops(@NotNull Level world, @NotNull BlockPos coords, int fortune, ItemStack stack, LivingEntity entity) {
        return world.getBlockState(coords).getDrops(new LootParams.Builder((ServerLevel)world).withLuck((float)fortune).withOptionalParameter(LootContextParams.BLOCK_ENTITY, (Object)world.getBlockEntity(coords)).withParameter(LootContextParams.ORIGIN, (Object)entity.position()).withParameter(LootContextParams.TOOL, (Object)stack));
    }

    public static Block getBlock(@NotNull Level world, @NotNull BlockPos coords) {
        return world.getBlockState(coords).getBlock();
    }

    public static BlockState getBlockState(@NotNull Level world, @NotNull BlockPos coords) {
        return world.getBlockState(coords);
    }

    public static boolean setBlock(@NotNull Level worldIn, @NotNull BlockPos coords, BlockState state, int flag) {
        return worldIn.setBlock(coords, state, flag);
    }

    public static void set(@NotNull BlockPos.MutableBlockPos pos, @NotNull BlockPos newPos) {
        pos.set(newPos.getX(), newPos.getY(), newPos.getZ());
    }

    public static boolean equals(@NotNull BlockPos coords, int x, int y, int z) {
        return coords.getX() == x && coords.getY() == y && coords.getZ() == z;
    }

    public static boolean equals(int x1, int y1, int z1, int x2, int y2, int z2) {
        return x1 == x2 && y1 == y2 && z1 == z2;
    }

    public static boolean equals(BlockPos pos1, BlockPos pos2) {
        return pos1.equals((Object)pos2);
    }

    @NotNull
    public static BlockPos fromEntity(@NotNull Entity entity) {
        return new BlockPos(Mth.floor((double)entity.getX()), Mth.floor((double)entity.getY()), Mth.floor((double)entity.getZ()));
    }

    @NotNull
    public static BlockPos getFloor(@NotNull BlockPos position, @NotNull Level world) {
        BlockPos floor = BlockPosUtil.getFloor(new BlockPos.MutableBlockPos(position.getX(), position.getY(), position.getZ()), 0, world);
        if (floor == null) {
            return position;
        }
        return floor;
    }

    @Nullable
    public static BlockPos getFloor(@NotNull BlockPos.MutableBlockPos position, int depth, @NotNull Level world) {
        if (depth > 50) {
            return null;
        }
        if (!EntityUtils.solidOrLiquid(world, (BlockPos)position)) {
            return BlockPosUtil.getFloor(position.set(position.getX(), position.getY() - 1, position.getZ()), depth + 1, world);
        }
        if (!EntityUtils.solidOrLiquid(world, (BlockPos)position.set(position.getX(), position.getY() + 1, position.getZ())) && !EntityUtils.solidOrLiquid(world, (BlockPos)position.set(position.getX(), position.getY() + 2, position.getZ()))) {
            return position.immutable();
        }
        return BlockPosUtil.getFloor(position.set(position.getX(), position.getY() + 1, position.getZ()), depth + 1, world);
    }

    public static Direction getFacing(BlockPos pos, BlockPos neighbor) {
        BlockPos vector = neighbor.subtract((Vec3i)pos);
        return BlockPosUtil.directionFromDelta(vector.getX(), vector.getY(), vector.getZ());
    }

    public static Direction getXZFacing(BlockPos pos, BlockPos neighbor) {
        BlockPos vector = neighbor.subtract((Vec3i)pos);
        return BlockPosUtil.directionFromDelta(vector.getX(), 0, vector.getZ());
    }

    public static Direction getXZFacing(int pos1X, int pos1Z, int pos2X, int pos2Z) {
        if (pos2X > pos1X) {
            return Direction.EAST;
        }
        if (pos2X < pos1X) {
            return Direction.WEST;
        }
        if (pos2Z < pos1Z) {
            return Direction.NORTH;
        }
        if (pos2Z > pos1Z) {
            return Direction.SOUTH;
        }
        return Direction.UP;
    }

    public static Direction directionFromDelta(int x, int y, int z) {
        if (x == 0) {
            if (y == 0) {
                if (z > 0) {
                    return Direction.SOUTH;
                }
                if (z < 0) {
                    return Direction.NORTH;
                }
            } else if (z == 0) {
                if (y > 0) {
                    return Direction.UP;
                }
                return Direction.DOWN;
            }
        } else if (y == 0 && z == 0) {
            if (x > 0) {
                return Direction.EAST;
            }
            return Direction.WEST;
        }
        return Direction.NORTH;
    }

    public static DirectionResult calcDirection(@NotNull BlockPos building, @NotNull BlockPos pos) {
        int zDiff;
        DirectionResult direction = DirectionResult.SAME;
        if (pos.getZ() == building.getZ() && pos.getX() == building.getX()) {
            if (pos.getY() > building.getY()) {
                return DirectionResult.UP;
            }
            if (pos.getY() < building.getY()) {
                return DirectionResult.DOWN;
            }
            return DirectionResult.SAME;
        }
        int xDiff = building.getX() - pos.getX();
        int degree = (int)(Math.atan2(xDiff, zDiff = building.getZ() - pos.getZ()) * 180.0 / Math.PI);
        if (degree < 0) {
            degree += 360;
        }
        direction = degree <= 22 || degree >= 338 ? DirectionResult.NORTH : (degree > 22 && degree < 67 ? DirectionResult.NORTH_WEST : (degree >= 67 && degree <= 112 ? DirectionResult.WEST : (degree > 112 && degree < 157 ? DirectionResult.SOUTH_WEST : (degree >= 157 && degree <= 202 ? DirectionResult.SOUTH : (degree > 202 && degree < 247 ? DirectionResult.SOUTH_EAST : (degree >= 247 && degree <= 292 ? DirectionResult.EAST : DirectionResult.NORTH_EAST))))));
        return direction;
    }

    public static BlockPos findAround(Level world, BlockPos start, int verticalRange, int horizontalRange, BiPredicate<BlockGetter, BlockPos> predicate) {
        if (horizontalRange < 1 && verticalRange < 1) {
            return null;
        }
        if (predicate.test((BlockGetter)world, start)) {
            return start;
        }
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!predicate.test((BlockGetter)world, start.relative(direction))) continue;
            return start.relative(direction);
        }
        int y = 0;
        int y_offset = 1;
        for (int i = 0; i < verticalRange + 2; ++i) {
            for (int steps = 1; steps <= horizontalRange; ++steps) {
                int z;
                int x;
                BlockPos temp = start.offset(-steps, y, -steps);
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(0, 0, 1))) continue;
                    return temp;
                }
                for (x = 0; x <= steps; ++x) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(-1, 0, 0))) continue;
                    return temp;
                }
                for (z = 0; z <= steps; ++z) {
                    if (!predicate.test((BlockGetter)world, temp = temp.offset(0, 0, -1))) continue;
                    return temp;
                }
            }
            y_offset = y_offset > 0 ? y_offset + 1 : y_offset - 1;
            if (WorldUtil.isInWorldHeight(start.getY() + (y += (y_offset *= -1)), world)) continue;
            return null;
        }
        return null;
    }

    public static BlockPos findSpawnPosAround(Level worldReader, BlockPos start) {
        return BlockPosUtil.findAround(worldReader, start, 1, 1, (world, pos) -> world.getBlockState(pos).isAir() && world.getBlockState(pos.above()).isAir());
    }

    public static BlockPos getFurthestCorner(BlockPos startPos, BlockPos boxStart, BlockPos boxEnd) {
        int minX = Math.min(boxStart.getX(), boxEnd.getX());
        int minZ = Math.min(boxStart.getZ(), boxEnd.getZ());
        int minY = Math.min(boxStart.getY(), boxEnd.getY());
        int maxX = Math.max(boxStart.getX(), boxEnd.getX());
        int maxZ = Math.max(boxStart.getZ(), boxEnd.getZ());
        int maxY = Math.max(boxStart.getY(), boxEnd.getY());
        int cornerX = maxX;
        if (Math.abs(startPos.getX() - minX) > Math.abs(startPos.getX() - maxX)) {
            cornerX = minX;
        }
        int cornerY = maxY;
        if (Math.abs(startPos.getY() - minY) > Math.abs(startPos.getY() - maxY)) {
            cornerY = minY;
        }
        int cornerZ = maxZ;
        if (Math.abs(startPos.getZ() - minZ) > Math.abs(startPos.getZ() - maxZ)) {
            cornerZ = minZ;
        }
        return new BlockPos(cornerX, cornerY, cornerZ);
    }

    public static boolean isInArea(BlockPos cornerA, BlockPos cornerB, BlockPos location) {
        int y2;
        int y1;
        int z2;
        int z1;
        int x2;
        int x1;
        if (cornerA.getX() <= cornerB.getX()) {
            x1 = cornerA.getX();
            x2 = cornerB.getX();
        } else {
            x2 = cornerA.getX();
            x1 = cornerB.getX();
        }
        if (cornerA.getZ() <= cornerB.getZ()) {
            z1 = cornerA.getZ();
            z2 = cornerB.getZ();
        } else {
            z2 = cornerA.getZ();
            z1 = cornerB.getZ();
        }
        if (cornerA.getY() <= cornerB.getY()) {
            y1 = cornerA.getY();
            y2 = cornerB.getY();
        } else {
            y2 = cornerA.getY();
            y1 = cornerB.getY();
        }
        return location.getX() >= x1 - 1 && location.getX() <= x2 + 1 && location.getY() >= y1 - 1 && location.getY() <= y2 + 1 && location.getZ() >= z1 - 1 && location.getZ() <= z2 + 1;
    }

    public static enum DirectionResult {
        NORTH("com.minecolonies.coremod.gui.direction.north", "com.minecolonies.coremod.gui.direction.north.short"),
        SOUTH("com.minecolonies.coremod.gui.direction.south", "com.minecolonies.coremod.gui.direction.south.short"),
        WEST("com.minecolonies.coremod.gui.direction.west", "com.minecolonies.coremod.gui.direction.west.short"),
        EAST("com.minecolonies.coremod.gui.direction.east", "com.minecolonies.coremod.gui.direction.east.short"),
        NORTH_WEST(List.of("com.minecolonies.coremod.gui.direction.north", "com.minecolonies.coremod.gui.direction.west"), List.of("com.minecolonies.coremod.gui.direction.north.short", "com.minecolonies.coremod.gui.direction.west.short")),
        NORTH_EAST(List.of("com.minecolonies.coremod.gui.direction.north", "com.minecolonies.coremod.gui.direction.east"), List.of("com.minecolonies.coremod.gui.direction.north.short", "com.minecolonies.coremod.gui.direction.east.short")),
        SOUTH_WEST(List.of("com.minecolonies.coremod.gui.direction.south", "com.minecolonies.coremod.gui.direction.west"), List.of("com.minecolonies.coremod.gui.direction.south.short", "com.minecolonies.coremod.gui.direction.west.short")),
        SOUTH_EAST(List.of("com.minecolonies.coremod.gui.direction.south", "com.minecolonies.coremod.gui.direction.east"), List.of("com.minecolonies.coremod.gui.direction.south.short", "com.minecolonies.coremod.gui.direction.east.short")),
        UP("com.minecolonies.coremod.gui.direction.up", "com.minecolonies.coremod.gui.direction.up"),
        DOWN("com.minecolonies.coremod.gui.direction.down", "com.minecolonies.coremod.gui.direction.down"),
        SAME("com.minecolonies.coremod.gui.direction.exact", "com.minecolonies.coremod.gui.direction.exact");

        private final Component longText;
        private final Component shortText;

        private DirectionResult(String longText, String shortText) {
            this.longText = Component.translatableEscape((String)longText, (Object[])new Object[0]);
            this.shortText = Component.translatableEscape((String)shortText, (Object[])new Object[0]);
        }

        private DirectionResult(List<String> longText, List<String> shortText) {
            this.longText = ComponentUtils.formatList(longText.stream().map(Component::translatable).toList(), (Component)Component.literal((String)"/"));
            this.shortText = ComponentUtils.formatList(shortText.stream().map(Component::translatable).toList(), (Component)Component.literal((String)"/"));
        }

        public Component getLongText() {
            return this.longText;
        }

        public Component getShortText() {
            return this.shortText;
        }
    }
}

