/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.crafting;

import com.minecolonies.apiimp.initializer.ModIngredientTypeInitializer;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import java.util.stream.Stream;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.neoforged.neoforge.common.crafting.ICustomIngredient;
import net.neoforged.neoforge.common.crafting.IngredientType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record CountedIngredient(@NotNull Ingredient child, int count) implements ICustomIngredient
{
    public static final MapCodec<CountedIngredient> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Ingredient.CODEC_NONEMPTY.fieldOf("item").forGetter(CountedIngredient::child), (App)ExtraCodecs.POSITIVE_INT.optionalFieldOf("count", (Object)1).forGetter(CountedIngredient::count)).apply((Applicative)builder, CountedIngredient::new));

    public CountedIngredient(@NotNull Ingredient child, int count) {
        if (child == Ingredient.EMPTY || count <= 0) {
            throw new IllegalArgumentException("Counted ingredient must have a child");
        }
    }

    public static Ingredient of(@NotNull Ingredient child, int count) {
        return count == 1 ? child : new CountedIngredient(child, count).toVanilla();
    }

    public boolean test(@Nullable ItemStack stack) {
        return this.child.test(stack);
    }

    public boolean isSimple() {
        return this.child.isSimple();
    }

    @NotNull
    public IngredientType<?> getType() {
        return (IngredientType)ModIngredientTypeInitializer.COUNTED_INGREDIENT_TYPE.get();
    }

    @NotNull
    public Stream<ItemStack> getItems() {
        return Arrays.stream(this.child.getItems()).map(ItemStack::copy).peek(s -> s.setCount(this.count));
    }
}

