/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.compatibility;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.compatibility.Compatibility;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.compatibility.dynamictrees.DynamicTreeCompat;
import com.minecolonies.api.compatibility.resourcefulbees.ResourcefulBeesCompat;
import com.minecolonies.api.compatibility.tinkers.SlimeTreeCheck;
import com.minecolonies.api.compatibility.tinkers.TinkersToolHelper;
import com.minecolonies.api.crafting.CompostRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.registry.ModRecipeSerializer;
import com.minecolonies.api.items.ModTags;
import com.minecolonies.api.util.CraftingUtils;
import com.minecolonies.api.util.FoodUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import com.minecolonies.api.util.NBTUtils;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.crafting.CustomRecipeManager;
import com.minecolonies.core.colony.crafting.LootTableAnalyzer;
import com.minecolonies.core.util.FurnaceRecipes;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.FurnaceBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.ModList;
import net.neoforged.neoforge.common.Tags;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompatibilityManager
implements ICompatibilityManager {
    private static final int MAX_DEPTH = 100;
    private final Map<Block, ItemStorage> leavesToSaplingMap = new HashMap<Block, ItemStorage>();
    private final List<ItemStorage> saplings = new ArrayList<ItemStorage>();
    private final Set<Block> oreBlocks = new HashSet<Block>();
    private final Set<ItemStorage> smeltableOres = new HashSet<ItemStorage>();
    private final Map<Item, RecipeHolder<CompostRecipe>> compostRecipes = new HashMap<Item, RecipeHolder<CompostRecipe>>();
    private final Set<ItemStorage> plantables = new HashSet<ItemStorage>();
    private final Set<ItemStorage> fuel = new HashSet<ItemStorage>();
    private final Set<ItemStorage> food = new HashSet<ItemStorage>();
    private final Set<ItemStorage> edibles = new HashSet<ItemStorage>();
    private ImmutableSet<ItemStorage> beekeeperflowers = ImmutableSet.of();
    private static ImmutableList<ItemStack> allItems = ImmutableList.of();
    private ImmutableSet<ResourceLocation> monsters = ImmutableSet.of();
    private final Map<ItemStorage, CreativeModeTab> creativeModeTabMap = new HashMap<ItemStorage, CreativeModeTab>();
    private final FurnaceRecipes furnaceRecipes = new FurnaceRecipes();
    private static final StreamCodec<RegistryFriendlyByteBuf, List<RecipeHolder<?>>> RECIPE_LIST_STREAM_CODEC = RecipeHolder.STREAM_CODEC.apply(ByteBufCodecs.list());

    private void clear() {
        this.saplings.clear();
        this.oreBlocks.clear();
        this.smeltableOres.clear();
        this.plantables.clear();
        this.beekeeperflowers = ImmutableSet.of();
        this.food.clear();
        this.edibles.clear();
        this.fuel.clear();
        this.compostRecipes.clear();
        this.monsters = ImmutableSet.of();
        this.creativeModeTabMap.clear();
    }

    @Override
    public void discover(@NotNull RecipeManager recipeManager, Level level) {
        this.clear();
        this.discoverAllItems(level);
        this.discoverModCompat();
        this.discoverCompostRecipes(recipeManager);
        this.discoverMobs();
    }

    @Override
    public void serialize(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(ItemStackUtils.CHECKED_NBT_KEYS.size());
        for (Map.Entry<Item, Set<DataComponentType<?>>> entry : ItemStackUtils.CHECKED_NBT_KEYS.entrySet()) {
            buf.writeInt(BuiltInRegistries.ITEM.getId((Object)entry.getKey()));
            buf.writeInt(entry.getValue().size());
            for (DataComponentType<?> key : entry.getValue()) {
                Utils.serializeCodecMess(DataComponentType.STREAM_CODEC, buf, key);
            }
        }
        CompatibilityManager.serializeItemStorageList(buf, this.saplings);
        CompatibilityManager.serializeBlockList(buf, this.oreBlocks);
        CompatibilityManager.serializeItemStorageList(buf, this.smeltableOres);
        CompatibilityManager.serializeItemStorageList(buf, this.plantables);
        CompatibilityManager.serializeItemStorageList(buf, this.beekeeperflowers);
        CompatibilityManager.serializeItemStorageList(buf, this.food);
        CompatibilityManager.serializeItemStorageList(buf, this.edibles);
        CompatibilityManager.serializeItemStorageList(buf, this.fuel);
        CompatibilityManager.serializeRegistryIds(buf, BuiltInRegistries.ENTITY_TYPE, this.monsters);
        CompatibilityManager.serializeCompostRecipes(buf, this.compostRecipes);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf, ClientLevel level) {
        this.clear();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            Item item = (Item)BuiltInRegistries.ITEM.byId(buf.readInt());
            HashSet<DataComponentType> nbtKeys = new HashSet<DataComponentType>();
            int children = buf.readInt();
            for (int j = 0; j < children; ++j) {
                nbtKeys.add((DataComponentType)Utils.deserializeCodecMess(DataComponentType.STREAM_CODEC, buf));
            }
            ItemStackUtils.CHECKED_NBT_KEYS.put(item, nbtKeys);
        }
        this.discoverAllItems((Level)level);
        this.saplings.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.oreBlocks.addAll(CompatibilityManager.deserializeBlockList(buf));
        this.smeltableOres.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.plantables.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.beekeeperflowers = ImmutableSet.copyOf(CompatibilityManager.deserializeItemStorageList(buf));
        this.food.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.edibles.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.fuel.addAll(CompatibilityManager.deserializeItemStorageList(buf));
        this.monsters = ImmutableSet.copyOf(CompatibilityManager.deserializeRegistryIds(buf, BuiltInRegistries.ENTITY_TYPE));
        Log.getLogger().info("Synchronized {} saplings", (Object)this.saplings.size());
        Log.getLogger().info("Synchronized {} ore blocks with {} smeltable ores", (Object)this.oreBlocks.size(), (Object)this.smeltableOres.size());
        Log.getLogger().info("Synchronized {} plantables", (Object)this.plantables.size());
        Log.getLogger().info("Synchronized {} flowers", (Object)this.beekeeperflowers.size());
        Log.getLogger().info("Synchronized {} food types with {} edible", (Object)this.food.size(), (Object)this.edibles.size());
        Log.getLogger().info("Synchronized {} fuel types", (Object)this.fuel.size());
        Log.getLogger().info("Synchronized {} monsters", (Object)this.monsters.size());
        this.discoverCompostRecipes(CompatibilityManager.deserializeCompostRecipes(buf));
        this.discoverModCompat();
    }

    private static void serializeItemStorageList(@NotNull RegistryFriendlyByteBuf buf, @NotNull Collection<ItemStorage> list) {
        buf.writeCollection(list, (buffer, storage) -> StandardFactoryController.getInstance().serialize((RegistryFriendlyByteBuf)buffer, storage));
    }

    @NotNull
    private static List<ItemStorage> deserializeItemStorageList(@NotNull RegistryFriendlyByteBuf buf) {
        return buf.readList(buffer -> (ItemStorage)StandardFactoryController.getInstance().deserialize((RegistryFriendlyByteBuf)buffer));
    }

    private static void serializeBlockList(@NotNull RegistryFriendlyByteBuf buf, @NotNull Collection<Block> list) {
        buf.writeCollection(list.stream().map(ItemStack::new).toList(), (b, stack) -> Utils.serializeCodecMess((RegistryFriendlyByteBuf)b, stack));
    }

    @NotNull
    private static List<Block> deserializeBlockList(@NotNull RegistryFriendlyByteBuf buf) {
        List stacks = buf.readList(b -> Utils.deserializeCodecMess((RegistryFriendlyByteBuf)b));
        return stacks.stream().flatMap(stack -> {
            Stream<Object> stream;
            Item patt0$temp = stack.getItem();
            if (patt0$temp instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)patt0$temp;
                stream = Stream.of(blockItem.getBlock());
            } else {
                stream = Stream.empty();
            }
            return stream;
        }).toList();
    }

    private static void serializeRegistryIds(@NotNull RegistryFriendlyByteBuf buf, @NotNull Registry<?> registry, @NotNull Collection<ResourceLocation> ids) {
        buf.writeCollection(ids, (b, id) -> b.writeResourceLocation(id));
    }

    @NotNull
    private static <T> List<ResourceLocation> deserializeRegistryIds(@NotNull RegistryFriendlyByteBuf buf, @NotNull Registry<T> registry) {
        return buf.readList(b -> b.readResourceLocation());
    }

    private static void serializeCompostRecipes(@NotNull RegistryFriendlyByteBuf buf, @NotNull Map<Item, RecipeHolder<CompostRecipe>> compostRecipes) {
        List<RecipeHolder<CompostRecipe>> recipes = compostRecipes.values().stream().distinct().toList();
        buf.writeCollection(recipes, (b, holder) -> RecipeHolder.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)b), holder));
    }

    @NotNull
    private static List<RecipeHolder<CompostRecipe>> deserializeCompostRecipes(@NotNull RegistryFriendlyByteBuf buf) {
        return buf.readList(b -> (RecipeHolder)RecipeHolder.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)b)));
    }

    @Override
    public List<ItemStack> getListOfAllItems() {
        if (allItems.isEmpty()) {
            Log.getLogger().error("getListOfAllItems when empty");
        }
        return allItems;
    }

    @Override
    public List<ItemStack> getListOfMatchingItems(Predicate<ItemStack> predicate) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (ItemStack stack : allItems) {
            if (!predicate.test(stack)) continue;
            list.add(stack);
        }
        return list;
    }

    @Override
    public Set<ItemStorage> getSetOfAllItems() {
        if (this.creativeModeTabMap.isEmpty()) {
            Log.getLogger().error("getSetOfAllItems when empty");
        }
        return this.creativeModeTabMap.keySet();
    }

    @Override
    public boolean isPlantable(ItemStack itemStack) {
        return !itemStack.isEmpty() && itemStack.getItem() instanceof BlockItem && itemStack.is(ModTags.floristFlowers);
    }

    @Override
    public boolean isLuckyBlock(Block block) {
        return block.defaultBlockState().is(ModTags.oreChanceBlocks);
    }

    @Override
    @Nullable
    public ItemStack getSaplingForLeaf(Block block) {
        if (this.leavesToSaplingMap.containsKey(block)) {
            return this.leavesToSaplingMap.get(block).getItemStack();
        }
        return null;
    }

    @Override
    public Set<ItemStorage> getCopyOfSaplings() {
        if (this.saplings.isEmpty()) {
            Log.getLogger().error("getCopyOfSaplings when empty");
        }
        return new HashSet<ItemStorage>(this.saplings);
    }

    @Override
    public Set<ItemStorage> getFuel() {
        if (this.fuel.isEmpty()) {
            Log.getLogger().error("getFuel when empty");
        }
        return this.fuel;
    }

    @Override
    public Set<ItemStorage> getFood() {
        if (this.food.isEmpty()) {
            Log.getLogger().error("getFood when empty");
        }
        return this.food;
    }

    @Override
    public Set<ItemStorage> getEdibles(int minNutrition) {
        if (this.edibles.isEmpty()) {
            Log.getLogger().error("getEdibles when empty");
        }
        HashSet<ItemStorage> filteredEdibles = new HashSet<ItemStorage>();
        for (ItemStorage storage : this.edibles) {
            if (storage.getItemStack().getFoodProperties(null) == null || storage.getItemStack().getFoodProperties(null).nutrition() < minNutrition) continue;
            filteredEdibles.add(storage);
        }
        return filteredEdibles;
    }

    @Override
    public Set<ItemStorage> getSmeltableOres() {
        if (this.smeltableOres.isEmpty()) {
            Log.getLogger().error("getSmeltableOres when empty");
        }
        return this.smeltableOres;
    }

    @Override
    public Map<Item, RecipeHolder<CompostRecipe>> getCopyOfCompostRecipes() {
        if (this.compostRecipes.isEmpty()) {
            Log.getLogger().error("getCopyOfCompostRecipes when empty");
        }
        return ImmutableMap.copyOf(this.compostRecipes);
    }

    @Override
    public Set<ItemStorage> getCompostInputs() {
        if (this.compostRecipes.isEmpty()) {
            Log.getLogger().error("getCompostInputs when empty");
        }
        return this.compostRecipes.keySet().stream().map(item -> new ItemStorage(new ItemStack((ItemLike)item))).collect(Collectors.toSet());
    }

    @Override
    public Set<ItemStorage> getCopyOfPlantables() {
        if (this.plantables.isEmpty()) {
            Log.getLogger().error("getCopyOfPlantables when empty");
        }
        return new HashSet<ItemStorage>(this.plantables);
    }

    @Override
    public Set<ItemStorage> getImmutableFlowers() {
        if (this.beekeeperflowers.isEmpty()) {
            Log.getLogger().error("getImmutableFlowers when empty");
        }
        return this.beekeeperflowers;
    }

    @Override
    public boolean isOre(BlockState block) {
        if (this.oreBlocks.isEmpty()) {
            Log.getLogger().error("isOre when empty");
        }
        return this.oreBlocks.contains(block.getBlock());
    }

    @Override
    public boolean isOre(@NotNull ItemStack stack) {
        if (this.isBreakableOre(stack)) {
            return true;
        }
        if (this.isMineableOre(stack) || stack.is(ModTags.raw_ore)) {
            ItemStack smeltingResult = MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack);
            return !smeltingResult.isEmpty();
        }
        return false;
    }

    @Override
    public boolean isMineableOre(@NotNull ItemStack stack) {
        return !ItemStackUtils.isEmpty(stack) && stack.is(Tags.Items.ORES);
    }

    @Override
    public boolean isBreakableOre(@NotNull ItemStack stack) {
        if (stack.is(ModTags.breakable_ore)) {
            Block block = Block.byItem((Item)stack.getItem());
            if (!block.defaultBlockState().isAir()) {
                List<LootTableAnalyzer.LootDrop> drops = CustomRecipeManager.getInstance().getLootDrops((ResourceKey<LootTable>)block.getLootTable());
                for (LootTableAnalyzer.LootDrop drop : drops) {
                    for (ItemStack dropStack : drop.getItemStacks()) {
                        if (!ItemStackUtils.compareItemStacksIgnoreStackSize(stack, dropStack).booleanValue()) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void write(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        @NotNull ListTag saplingsLeavesTagList = this.leavesToSaplingMap.entrySet().stream().filter(entry -> entry.getKey() != null && !((ItemStorage)entry.getValue()).getItemStack().isEmpty()).map(entry -> CompatibilityManager.writeLeafSaplingEntryToNBT(provider, ((Block)entry.getKey()).defaultBlockState(), (ItemStorage)entry.getValue())).collect(NBTUtils.toListNBT());
        compound.put("tagSapLeaves", (Tag)saplingsLeavesTagList);
    }

    @Override
    public void read(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        NBTUtils.streamCompound(compound.getList("tagSapLeaves", 10)).map(nbt -> CompatibilityManager.readLeafSaplingEntryFromNBT(provider, nbt)).filter(key -> !((BlockState)key.getA()).isAir() && !this.leavesToSaplingMap.containsKey(((BlockState)key.getA()).getBlock()) && !this.leavesToSaplingMap.containsValue(key.getB())).forEach(key -> this.leavesToSaplingMap.put(((BlockState)key.getA()).getBlock(), (ItemStorage)key.getB()));
    }

    @Override
    public void connectLeafToSapling(Block leaf, ItemStack stack) {
        if (!this.leavesToSaplingMap.containsKey(leaf)) {
            this.leavesToSaplingMap.put(leaf, new ItemStorage(stack, false, true));
        }
    }

    @Override
    public CreativeModeTab getCreativeTab(ItemStorage checkItem) {
        return this.creativeModeTabMap.get(checkItem);
    }

    @Override
    public int getCreativeTabKey(ItemStorage checkItem) {
        CreativeModeTab creativeTab = this.creativeModeTabMap.get(checkItem);
        return creativeTab == null ? 0 : this.creativeModeTabMap.get(checkItem).column();
    }

    @Override
    public ImmutableSet<ResourceLocation> getAllMonsters() {
        if (this.monsters.isEmpty()) {
            Log.getLogger().error("getAllMonsters when empty");
        }
        return this.monsters;
    }

    private void discoverMobs() {
        HashSet<ResourceLocation> monsterSet = new HashSet<ResourceLocation>();
        for (Map.Entry entry : BuiltInRegistries.ENTITY_TYPE.entrySet()) {
            if (((EntityType)entry.getValue()).getCategory() == MobCategory.MONSTER) {
                monsterSet.add(((ResourceKey)entry.getKey()).location());
                continue;
            }
            if (!((EntityType)entry.getValue()).is(ModTags.hostile)) continue;
            monsterSet.add(((ResourceKey)entry.getKey()).location());
        }
        this.monsters = ImmutableSet.copyOf(monsterSet);
    }

    private void discoverAllItems(Level level) {
        if (!this.food.isEmpty()) {
            return;
        }
        HashSet tempDuplicates = new HashSet();
        HashSet tempFlowers = new HashSet();
        CreativeModeTab.ItemDisplayParameters tempDisplayParams = new CreativeModeTab.ItemDisplayParameters(level.enabledFeatures(), false, (HolderLookup.Provider)level.registryAccess());
        ImmutableList.Builder listBuilder = new ImmutableList.Builder();
        CraftingUtils.forEachCreativeTabItems(tempDisplayParams, (tab, stacks) -> {
            Object2IntLinkedOpenHashMap mapping = new Object2IntLinkedOpenHashMap();
            for (ItemStack item : stacks) {
                if (!tempDuplicates.add(new ItemStorage(item)) || mapping.addTo((Object)item.getItem(), 1) > 100) continue;
                listBuilder.add((Object)item);
                this.discoverSaplings(item);
                this.discoverOres(item);
                this.discoverPlantables(item);
                this.discoverFood(item);
                this.discoverFuel(item);
                this.discoverBeekeeperFlowers(item, tempFlowers);
                this.creativeModeTabMap.put(new ItemStorage(item), (CreativeModeTab)tab);
            }
        });
        this.discoverFungi();
        this.beekeeperflowers = ImmutableSet.copyOf(tempFlowers);
        Log.getLogger().info("Finished discovering Ores " + this.oreBlocks.size() + " " + this.smeltableOres.size());
        Log.getLogger().info("Finished discovering saplings " + this.saplings.size());
        Log.getLogger().info("Finished discovering plantables " + this.plantables.size());
        Log.getLogger().info("Finished discovering food " + this.edibles.size() + " " + this.food.size());
        Log.getLogger().info("Finished discovering fuel " + this.fuel.size());
        Log.getLogger().info("Finished discovering flowers " + this.beekeeperflowers.size());
        allItems = listBuilder.build();
        Log.getLogger().info("Finished discovering items " + allItems.size());
    }

    private void discoverBeekeeperFlowers(ItemStack item, Set<ItemStorage> tempFlowers) {
        if (item.is(ItemTags.FLOWERS)) {
            tempFlowers.add(new ItemStorage(item));
        }
    }

    private void discoverOres(ItemStack stack) {
        if (stack.is(Tags.Items.ORES) || stack.is(ModTags.breakable_ore) || stack.is(ModTags.raw_ore)) {
            if (stack.getItem() instanceof BlockItem) {
                this.oreBlocks.add(((BlockItem)stack.getItem()).getBlock());
            }
            if (!MinecoloniesAPIProxy.getInstance().getFurnaceRecipes().getSmeltingResult(stack).isEmpty()) {
                this.smeltableOres.add(new ItemStorage(stack));
            }
        }
    }

    private void discoverSaplings(ItemStack stack) {
        if (stack.is(ItemTags.SAPLINGS) || stack.is(Tags.Items.MUSHROOMS) || stack.is(ModTags.fungi)) {
            this.saplings.add(new ItemStorage(stack, false, true));
        }
    }

    private void discoverFungi() {
        this.leavesToSaplingMap.put(Blocks.NETHER_WART_BLOCK, new ItemStorage(new ItemStack((ItemLike)Items.CRIMSON_FUNGUS)));
        this.leavesToSaplingMap.put(Blocks.WARPED_WART_BLOCK, new ItemStorage(new ItemStack((ItemLike)Items.WARPED_FUNGUS)));
    }

    private void discoverCompostRecipes(@NotNull RecipeManager recipeManager) {
        if (this.compostRecipes.isEmpty()) {
            this.discoverCompostRecipes(recipeManager.getAllRecipesFor((RecipeType)ModRecipeSerializer.CompostRecipeType.get()));
            Log.getLogger().info("Finished discovering compostables " + this.compostRecipes.size());
        }
    }

    private void discoverCompostRecipes(@NotNull List<RecipeHolder<CompostRecipe>> recipes) {
        for (RecipeHolder<CompostRecipe> recipe : recipes) {
            for (ItemStack stack : ((CompostRecipe)recipe.value()).getInput().getItems()) {
                this.compostRecipes.merge(stack.getItem(), recipe, (r1, r2) -> ((CompostRecipe)r1.value()).getStrength() < ((CompostRecipe)r2.value()).getStrength() ? r1 : r2);
            }
        }
    }

    private void discoverPlantables(ItemStack stack) {
        if (stack.is(ModTags.floristFlowers) && stack.getItem() instanceof BlockItem) {
            this.plantables.add(new ItemStorage(stack));
        }
    }

    private void discoverFuel(ItemStack stack) {
        if (FurnaceBlockEntity.isFuel((ItemStack)stack)) {
            this.fuel.add(new ItemStorage(stack));
        }
    }

    private void discoverFood(ItemStack stack) {
        if (ItemStackUtils.ISFOOD.test(stack) || ItemStackUtils.ISCOOKABLE.test(stack)) {
            this.food.add(new ItemStorage(stack));
            if (FoodUtils.EDIBLE.test(stack)) {
                this.edibles.add(new ItemStorage(stack));
            }
        }
    }

    private static CompoundTag writeLeafSaplingEntryToNBT(@NotNull HolderLookup.Provider provider, BlockState state, ItemStorage storage) {
        CompoundTag compound = NbtUtils.writeBlockState((BlockState)state);
        compound.put("stack", storage.getItemStack().saveOptional(provider));
        return compound;
    }

    private static Tuple<BlockState, ItemStorage> readLeafSaplingEntryFromNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        return new Tuple<BlockState, ItemStorage>(NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)compound), new ItemStorage(ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)compound.getCompound("stack")), false, true));
    }

    private void discoverModCompat() {
        if (ModList.get().isLoaded("resourcefulbees")) {
            Compatibility.beeHiveCompat = new ResourcefulBeesCompat();
        }
        if (ModList.get().isLoaded("tconstruct")) {
            Compatibility.tinkersCompat = new TinkersToolHelper();
            Compatibility.tinkersSlimeCompat = new SlimeTreeCheck();
        }
        if (ModList.get().isLoaded("dynamictrees")) {
            Compatibility.dynamicTreesCompat = new DynamicTreeCompat();
        }
    }

    @Override
    public FurnaceRecipes getFurnaceRecipes() {
        return this.furnaceRecipes;
    }

    @Override
    public int getNumberOfSaplings() {
        return this.saplings.size();
    }
}

