/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.util.Log;

public abstract class AbstractBuildingModule
implements IBuildingModule {
    public boolean isDirty = false;
    protected IBuilding building;
    private BuildingEntry.ModuleProducer producer = null;

    @Override
    public void markDirty() {
        this.isDirty = true;
        if (this.building != null) {
            this.building.markDirty();
        }
    }

    @Override
    public void clearDirty() {
        this.isDirty = false;
    }

    @Override
    public boolean checkDirty() {
        return this.isDirty;
    }

    @Override
    public IBuilding getBuilding() {
        return this.building;
    }

    @Override
    public IBuildingModule setBuilding(IBuilding building) {
        this.building = building;
        return this;
    }

    @Override
    public IBuildingModule setProducer(BuildingEntry.ModuleProducer moduleSet) {
        if (this.producer != null) {
            Log.getLogger().error("Changing a producer is not allowed, trace:", (Throwable)new Exception());
            return this;
        }
        this.producer = moduleSet;
        return this;
    }

    @Override
    public BuildingEntry.ModuleProducer getProducer() {
        return this.producer;
    }
}

