/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.advancements;

import com.minecolonies.api.advancements.AdvancementTriggers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import org.jetbrains.annotations.NotNull;

public class OpenGuiWindowTrigger
extends SimpleCriterionTrigger<OpenGuiWindowTriggerInstance> {
    public void trigger(ServerPlayer player, ResourceLocation windowResource) {
        this.trigger(player, trigger -> trigger.test(windowResource));
    }

    @NotNull
    public Codec<OpenGuiWindowTriggerInstance> codec() {
        return OpenGuiWindowTriggerInstance.CODEC;
    }

    public record OpenGuiWindowTriggerInstance(Optional<ContextAwarePredicate> player, Optional<ResourceLocation> windowResource) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static final Codec<OpenGuiWindowTriggerInstance> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(OpenGuiWindowTriggerInstance::player), (App)ResourceLocation.CODEC.optionalFieldOf("window_resource_location").forGetter(OpenGuiWindowTriggerInstance::windowResource)).apply((Applicative)builder, OpenGuiWindowTriggerInstance::new));

        public static Criterion<OpenGuiWindowTriggerInstance> openGuiWindow() {
            return OpenGuiWindowTriggerInstance.openGuiWindow(null);
        }

        public static Criterion<OpenGuiWindowTriggerInstance> openGuiWindow(ResourceLocation windowResource) {
            return ((OpenGuiWindowTrigger)((Object)AdvancementTriggers.OPEN_GUI_WINDOW.get())).createCriterion((CriterionTriggerInstance)new OpenGuiWindowTriggerInstance(Optional.empty(), Optional.ofNullable(windowResource)));
        }

        public boolean test(ResourceLocation windowResource) {
            return this.windowResource.map(resourceLocation -> resourceLocation.equals((Object)windowResource)).orElse(true);
        }
    }
}

