/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.util;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.crafting.ExactMatchItemStorage;
import com.minecolonies.api.inventory.api.CombinedItemHandler;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.Log;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public final class SortingUtils {
    private SortingUtils() {
    }

    public static void sort(@NotNull HolderLookup.Provider provider, CombinedItemHandler inv) {
        CompoundTag backup = inv.serializeNBT(provider);
        AtomicInteger runCount = new AtomicInteger(0);
        try {
            HashMap<ExactMatchItemStorage, Integer> map = new HashMap<ExactMatchItemStorage, Integer>();
            if (inv != null) {
                for (int i = 0; i < inv.getSlots(); ++i) {
                    if (ItemStackUtils.isEmpty(inv.getStackInSlot(i))) continue;
                    ExactMatchItemStorage storage = new ExactMatchItemStorage(inv.getStackInSlot(i));
                    inv.setStackInSlot(i, ItemStack.EMPTY);
                    int amount = storage.getAmount();
                    if (map.containsKey(storage)) {
                        amount += ((Integer)map.remove(storage)).intValue();
                    }
                    map.put(storage, amount);
                }
                Tuple<AtomicInteger, Map<Integer, Integer>> tuple = SortingUtils.calcRequiredSlots(map);
                double totalSlots = inv.getSlots();
                int totalReq = ((AtomicInteger)tuple.getA()).get();
                map.entrySet().stream().sorted(SortingUtils::compare).forEach(entry -> SortingUtils.pushIntoInv(runCount, entry, inv, (AtomicInteger)tuple.getA(), totalSlots, totalReq, (Map)tuple.getB()));
            }
        }
        catch (Exception e) {
            inv.deserializeNBT(provider, backup);
            Log.getLogger().warn("Minecolonies warehouse sorting had an error, report it to the mod author.", (Throwable)e);
        }
    }

    private static void pushIntoInv(AtomicInteger currentSlot, Map.Entry<ExactMatchItemStorage, Integer> entry, CombinedItemHandler inv, AtomicInteger requiredSlots, double totalSlots, double totalRequirement, Map<Integer, Integer> creativeTabs) {
        int creativeTabId = IColonyManager.getInstance().getCompatibilityManager().getCreativeTabKey(entry.getKey());
        int slotLimit = 0;
        ItemStack stack = entry.getKey().getItemStack();
        int tempSize = entry.getValue();
        while (tempSize > 0) {
            ItemStack tempStack = stack.copy();
            tempStack.setCount(Math.min(tempSize, tempStack.getMaxStackSize()));
            tempSize -= tempStack.getCount();
            slotLimit = inv.getLastIndex(currentSlot.get());
            for (int i = 0; i < 5 && !(tempStack = inv.insertItem(currentSlot.getAndIncrement(), tempStack, false)).isEmpty(); ++i) {
                Log.getLogger().error("Could not insert full stack into slot, remaining:" + String.valueOf(tempStack));
            }
            requiredSlots.decrementAndGet();
            creativeTabs.put(creativeTabId, creativeTabs.get(creativeTabId) - 1);
        }
        if (creativeTabs.get(creativeTabId) <= 0 && totalSlots - (double)slotLimit >= (double)requiredSlots.get()) {
            double dumpedSlots = totalRequirement - (double)requiredSlots.get();
            double usageFactor = totalSlots / dumpedSlots;
            double theoreticalJumpFactor = (totalSlots - (double)slotLimit) / (double)requiredSlots.get();
            if (theoreticalJumpFactor <= usageFactor || theoreticalJumpFactor > 4.0) {
                currentSlot.set(slotLimit);
            }
        }
    }

    private static int compare(Map.Entry<ExactMatchItemStorage, Integer> t1, Map.Entry<ExactMatchItemStorage, Integer> t2) {
        int id2;
        int creativeTabId2;
        int creativeTabId1 = IColonyManager.getInstance().getCompatibilityManager().getCreativeTabKey(t1.getKey());
        if (creativeTabId1 != (creativeTabId2 = IColonyManager.getInstance().getCompatibilityManager().getCreativeTabKey(t2.getKey()))) {
            return creativeTabId1 - creativeTabId2;
        }
        int id1 = SortingUtils.getId(t1.getKey().getItem());
        if (id1 == (id2 = SortingUtils.getId(t2.getKey().getItem()))) {
            return t1.getKey().getDamageValue() - t2.getKey().getDamageValue();
        }
        return id1 - id2;
    }

    private static int getId(Item item) {
        return BuiltInRegistries.ITEM.getId((Object)item);
    }

    private static Tuple<AtomicInteger, Map<Integer, Integer>> calcRequiredSlots(Map<ExactMatchItemStorage, Integer> map) {
        HashMap<Integer, Integer> creativeTabs = new HashMap<Integer, Integer>();
        int sum = 0;
        for (Map.Entry<ExactMatchItemStorage, Integer> entry : map.entrySet()) {
            sum = (int)((double)sum + Math.ceil((double)entry.getValue().intValue() / (double)entry.getKey().getItemStack().getMaxStackSize()));
            int index = IColonyManager.getInstance().getCompatibilityManager().getCreativeTabKey(entry.getKey());
            creativeTabs.put(index, creativeTabs.getOrDefault(index, 0) + (int)Math.ceil((double)entry.getValue().intValue() / (double)entry.getKey().getItemStack().getMaxStackSize()));
        }
        return new Tuple((Object)new AtomicInteger(sum), creativeTabs);
    }
}

