/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.tileentities;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.requestsystem.requestable.deliveryman.AbstractDeliverymanRequestable;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.tileentities.AbstractTileEntityRack;
import com.minecolonies.api.tileentities.MinecoloniesTileEntities;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemStackHandler;

public class TileEntityStash
extends TileEntityColonyBuilding {
    public TileEntityStash(BlockEntityType<? extends TileEntityStash> type, BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends AbstractTileEntityColonyBuilding>)type, pos, state);
    }

    public TileEntityStash(BlockPos pos, BlockState state) {
        super((BlockEntityType<? extends AbstractTileEntityColonyBuilding>)((BlockEntityType)MinecoloniesTileEntities.STASH.get()), pos, state);
    }

    @Override
    public ItemStackHandler createInventory(int slots) {
        return new NotifyingRackInventory(slots);
    }

    public class NotifyingRackInventory
    extends AbstractTileEntityRack.RackInventory {
        public NotifyingRackInventory(int defaultSize) {
            super(defaultSize);
        }

        @Override
        protected void onContentsChanged(int slot) {
            IColony colony;
            super.onContentsChanged(slot);
            if (TileEntityStash.this.level != null && !((TileEntityStash)TileEntityStash.this).level.isClientSide && IColonyManager.getInstance().isCoordinateInAnyColony(TileEntityStash.this.level, TileEntityStash.this.worldPosition) && (colony = IColonyManager.getInstance().getClosestColony(TileEntityStash.this.level, TileEntityStash.this.worldPosition)) != null) {
                IBuilding building = colony.getBuildingManager().getBuilding(TileEntityStash.this.worldPosition);
                if (!TileEntityStash.this.isEmpty() && building != null && building.createPickupRequest(AbstractDeliverymanRequestable.getPlayerActionPriority(true))) {
                    MessageUtils.format("entity.deliveryman.forcepickup", new Object[0]).sendToClose(TileEntityStash.this.getTilePos(), 6, colony.getMessagePlayerEntities());
                }
            }
        }
    }
}

