/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.placementhandlers;

import com.ldtteam.structurize.api.RotationMirror;
import com.ldtteam.structurize.placement.handlers.placement.IPlacementHandler;
import com.ldtteam.structurize.util.BlockUtils;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.InfestedBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class InfestedBlocksPlacementHandler
implements IPlacementHandler {
    public boolean canHandle(Level world, BlockPos pos, BlockState blockState) {
        return blockState.getBlock() instanceof InfestedBlock;
    }

    public IPlacementHandler.ActionProcessingResult handle(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete, BlockPos centerPos, RotationMirror settings) {
        BlockState expectedBlockState = InfestedBlocksPlacementHandler.getExpectedBlockState(blockState, complete);
        if (expectedBlockState == null) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (world.getBlockState(pos).equals(expectedBlockState)) {
            return IPlacementHandler.ActionProcessingResult.PASS;
        }
        if (!world.setBlock(pos, expectedBlockState, 3)) {
            return IPlacementHandler.ActionProcessingResult.DENY;
        }
        return IPlacementHandler.ActionProcessingResult.SUCCESS;
    }

    @Nullable
    private static BlockState getExpectedBlockState(BlockState blockState, boolean complete) {
        Block block = blockState.getBlock();
        if (block instanceof InfestedBlock) {
            InfestedBlock infestedBlock = (InfestedBlock)block;
            if (complete) {
                return blockState;
            }
            return infestedBlock.hostStateByInfested(blockState);
        }
        return null;
    }

    public List<ItemStack> getRequiredItems(Level world, BlockPos pos, BlockState blockState, @Nullable CompoundTag tileEntityData, boolean complete) {
        BlockState expectedBlockState = InfestedBlocksPlacementHandler.getExpectedBlockState(blockState, complete);
        return expectedBlockState != null ? List.of(BlockUtils.getItemStackFromBlockState((BlockState)expectedBlockState)) : List.of();
    }
}

