/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.postbox;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.requestsystem.requestable.Stack;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.colony.buildings.workerbuildings.PostBox;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class PostBoxRequestMessage
extends AbstractBuildingServerMessage<PostBox> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"post_box_request", PostBoxRequestMessage::new);
    private final ItemStack itemStack;
    private final boolean deliverAvailable;
    private final int reqQuantity;

    public PostBoxRequestMessage(@NotNull IBuildingView building, ItemStack itemStack, int quantity, boolean deliverAvailable) {
        super(TYPE, building);
        this.itemStack = itemStack;
        this.reqQuantity = quantity;
        this.deliverAvailable = deliverAvailable;
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        Utils.serializeCodecMess(buf, this.itemStack);
        buf.writeBoolean(this.deliverAvailable);
        buf.writeInt(this.reqQuantity);
    }

    protected PostBoxRequestMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.itemStack = Utils.deserializeCodecMess(buf);
        this.deliverAvailable = buf.readBoolean();
        this.reqQuantity = buf.readInt();
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, PostBox building) {
        int minCount = this.deliverAvailable ? 1 : this.reqQuantity;
        Stack requestStack = new Stack(this.itemStack, this.reqQuantity, minCount);
        building.createRequest(requestStack, false);
    }
}

