/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building.fields;

import com.ldtteam.common.network.AbstractServerPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.core.colony.buildingextensions.FarmField;
import com.minecolonies.core.tileentities.TileEntityScarecrow;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public class FarmFieldPlotResizeMessage
extends AbstractServerPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"farm_field_plot_resize", FarmFieldPlotResizeMessage::new);
    private final int size;
    private final Direction direction;
    private final BlockPos position;

    public FarmFieldPlotResizeMessage(int size, Direction direction, BlockPos position) {
        super(TYPE);
        this.size = size;
        this.direction = direction;
        this.position = position;
    }

    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player) {
        BlockEntity fieldBlock = player.level().getBlockEntity(this.position);
        if (fieldBlock instanceof TileEntityScarecrow) {
            TileEntityScarecrow scarecrow = (TileEntityScarecrow)fieldBlock;
            int currentSum = Arrays.stream(scarecrow.getFieldSize()).sum();
            int currentDirSize = scarecrow.getFieldSize()[this.direction.get2DDataValue()];
            if (this.size < 0 || this.size > currentDirSize && currentSum - currentDirSize + this.size > 20) {
                return;
            }
            scarecrow.setFieldSize(this.direction, this.size);
            IColony colony = scarecrow.getCurrentColony();
            if (colony != null) {
                colony.getBuildingManager().getMatchingBuildingExtension(f -> f.getBuildingExtensionType().equals(BuildingExtensionRegistries.farmField.get()) && f.getPosition().equals((Object)this.position)).map(m -> (FarmField)m).ifPresent(field -> field.setRadius(this.direction, this.size));
            }
        }
    }

    protected void toBytes(RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.size);
        buf.writeInt(this.direction.get2DDataValue());
        buf.writeBlockPos(this.position);
    }

    protected FarmFieldPlotResizeMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.size = buf.readInt();
        this.direction = Direction.from2DDataValue((int)buf.readInt());
        this.position = buf.readBlockPos();
    }
}

