/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.HiringMode;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildings.modules.CourierAssignmentModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class CourierHiringModeMessage
extends AbstractBuildingServerMessage<IBuilding> {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"courier_hiring_mode", CourierHiringModeMessage::new);
    private final int id;
    private final HiringMode mode;

    public CourierHiringModeMessage(@NotNull IBuildingView building, HiringMode mode, int id) {
        super(TYPE, building);
        this.mode = mode;
        this.id = id;
    }

    protected CourierHiringModeMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.mode = HiringMode.values()[buf.readInt()];
        this.id = buf.readInt();
    }

    @Override
    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeInt(this.mode.ordinal());
        buf.writeInt(this.id);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony, IBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.id);
        if (iBuildingModule instanceof CourierAssignmentModule) {
            CourierAssignmentModule module = (CourierAssignmentModule)iBuildingModule;
            module.setHiringMode(this.mode);
        }
    }
}

