/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony;

import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.connections.DiplomacyStatus;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.util.InventoryUtils;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingGateHouse;
import com.minecolonies.core.network.messages.server.AbstractColonyServerMessage;
import com.minecolonies.core.tileentities.TileEntityColonyBuilding;
import com.minecolonies.core.util.TeleportHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.Nullable;

public class TeleportToColonyMessage
extends AbstractColonyServerMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forServer((String)"minecolonies", (String)"teleport_to_colony", TeleportToColonyMessage::new);
    private int originColonyId;
    private int cost;
    private BlockPos pos;

    public TeleportToColonyMessage(ResourceKey<Level> dimensionId, int colonyId, BlockPos pos, int originColonyId, int cost) {
        super(TYPE, dimensionId, colonyId);
        this.pos = pos;
        this.originColonyId = originColonyId;
        this.cost = cost;
    }

    protected TeleportToColonyMessage(RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.pos = buf.readBlockPos();
        this.originColonyId = buf.readInt();
        this.cost = buf.readInt();
    }

    @Override
    @Nullable
    protected Action permissionNeeded() {
        return null;
    }

    @Override
    protected void toBytes(RegistryFriendlyByteBuf buf) {
        super.toBytes(buf);
        buf.writeBlockPos(this.pos);
        buf.writeInt(this.originColonyId);
        buf.writeInt(this.cost);
    }

    @Override
    protected void onExecute(IPayloadContext ctxIn, ServerPlayer player, IColony colony) {
        if (player == null) {
            return;
        }
        IColony originColony = IColonyManager.getInstance().getColonyByDimension(this.originColonyId, (ResourceKey<Level>)player.level().dimension());
        if (originColony == null) {
            return;
        }
        if (originColony.getConnectionManager().getColonyDiplomacyStatus(colony.getID()) != DiplomacyStatus.ALLIES) {
            return;
        }
        if (originColony.getPermissions().hasPermission((Player)player, Action.TELEPORT_TO_COLONY) || colony.getPermissions().hasPermission((Player)player, Action.TELEPORT_TO_COLONY)) {
            BlockEntity gateHouse = colony.getWorld().getBlockEntity(this.pos);
            if (gateHouse instanceof TileEntityColonyBuilding && ((TileEntityColonyBuilding)gateHouse).getBuilding() instanceof BuildingGateHouse) {
                List<BlockPos> posList;
                if (this.cost > 0 && InventoryUtils.attemptReduceStackInItemHandler((IItemHandler)new InvWrapper((Container)player.getInventory()), new ItemStack((ItemLike)Items.GOLD_NUGGET), this.cost)) {
                    int output = this.cost / 2;
                    if (output <= 64) {
                        InventoryUtils.addItemStackToItemHandler((IItemHandler)((TileEntityColonyBuilding)gateHouse).getInventory(), new ItemStack((ItemLike)Items.GOLD_NUGGET, output));
                    } else {
                        for (int i = 0; i < output / 64; ++i) {
                            if (output <= 0) continue;
                            int qty = Math.min(64, output);
                            InventoryUtils.addItemStackToItemHandler((IItemHandler)((TileEntityColonyBuilding)gateHouse).getInventory(), new ItemStack((ItemLike)Items.GOLD_NUGGET, qty));
                            output -= qty;
                        }
                    }
                }
                if ((posList = ((TileEntityColonyBuilding)gateHouse).getCachedWorldTagNamePosMap().get("gate")) == null || posList.isEmpty()) {
                    TeleportHelper.colonyTeleport(player, colony, this.pos);
                } else {
                    TeleportHelper.colonyTeleport(player, colony, posList.get(MathUtils.RANDOM.nextInt(posList.size())));
                }
            } else {
                TeleportHelper.colonyTeleport(player, colony, this.pos);
            }
        }
    }
}

