/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.workorders.IServerWorkOrder;
import com.minecolonies.core.colony.Colony;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewWorkOrderMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"colony_view_workorder", ColonyViewWorkOrderMessage::new);
    private final int colonyId;
    private final ResourceKey<Level> dimension;
    private final RegistryFriendlyByteBuf workOrderBuffer;

    public ColonyViewWorkOrderMessage(@NotNull Colony colony, @NotNull List<IServerWorkOrder> workOrderList) {
        super(TYPE);
        this.colonyId = colony.getID();
        this.workOrderBuffer = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.buffer()), colony.getWorld().registryAccess());
        this.dimension = colony.getDimension();
        this.workOrderBuffer.writeInt(workOrderList.size());
        for (IServerWorkOrder workOrder : workOrderList) {
            workOrder.serializeViewNetworkData(this.workOrderBuffer);
        }
    }

    public ColonyViewWorkOrderMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.colonyId = buf.readInt();
        this.dimension = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)buf.readUtf(Short.MAX_VALUE)));
        this.workOrderBuffer = new RegistryFriendlyByteBuf((ByteBuf)new FriendlyByteBuf(Unpooled.wrappedBuffer((byte[])buf.readByteArray())), buf.registryAccess());
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        this.workOrderBuffer.resetReaderIndex();
        buf.writeInt(this.colonyId);
        buf.writeUtf(this.dimension.location().toString());
        buf.writeByteArray(this.workOrderBuffer.array());
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        IColonyManager.getInstance().handleColonyViewWorkOrderMessage(this.colonyId, this.workOrderBuffer, this.dimension);
    }
}

