/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.ldtteam.common.network.AbstractClientPlayMessage;
import com.ldtteam.common.network.PlayMessageType;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.core.colony.Colony;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ColonyViewRemoveCitizenMessage
extends AbstractClientPlayMessage {
    public static final PlayMessageType<?> TYPE = PlayMessageType.forClient((String)"minecolonies", (String)"colony_view_remove_citizen", ColonyViewRemoveCitizenMessage::new);
    private final int colonyId;
    private final int citizenId;

    public ColonyViewRemoveCitizenMessage(@NotNull Colony colony, int citizen) {
        super(TYPE);
        this.colonyId = colony.getID();
        this.citizenId = citizen;
    }

    protected ColonyViewRemoveCitizenMessage(@NotNull RegistryFriendlyByteBuf buf, PlayMessageType<?> type) {
        super(buf, type);
        this.colonyId = buf.readInt();
        this.citizenId = buf.readInt();
    }

    protected void toBytes(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeInt(this.colonyId);
        buf.writeInt(this.citizenId);
    }

    protected void onExecute(IPayloadContext ctxIn, Player player) {
        IColonyManager.getInstance().handleColonyViewRemoveCitizenMessage(this.colonyId, this.citizenId, (ResourceKey<Level>)player.level().dimension());
    }
}

