/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.core.entity.other.SpearEntity;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemSpear
extends TridentItem {
    public ItemSpear(Item.Properties properties) {
        super(properties.durability(250));
    }

    public void releaseUsing(@NotNull ItemStack stack, @NotNull Level worldIn, @NotNull LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player playerEntity = (Player)entityLiving;
            int usedForDuration = this.getUseDuration(stack, entityLiving) - timeLeft;
            if (usedForDuration >= 10) {
                if (!worldIn.isClientSide) {
                    stack.hurtAndBreak(1, (LivingEntity)playerEntity, EquipmentSlot.MAINHAND);
                    SpearEntity spearEntity = new SpearEntity(worldIn, (LivingEntity)playerEntity, stack);
                    if (playerEntity.getAbilities().instabuild) {
                        spearEntity.pickup = AbstractArrow.Pickup.CREATIVE_ONLY;
                    } else {
                        playerEntity.getInventory().removeItem(stack);
                    }
                    worldIn.addFreshEntity((Entity)spearEntity);
                    worldIn.playSound(null, (Entity)spearEntity, (SoundEvent)SoundEvents.TRIDENT_THROW.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
                SoundEvent soundEvent = (SoundEvent)SoundEvents.TRIDENT_THROW.value();
                playerEntity.awardStat(Stats.ITEM_USED.get((Object)this));
                worldIn.playSound(null, (Entity)playerEntity, soundEvent, SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level world, Player playerEntity, @NotNull InteractionHand hand) {
        ItemStack itemstack = playerEntity.getItemInHand(hand);
        if (itemstack.getDamageValue() >= itemstack.getMaxDamage() - 1) {
            return InteractionResultHolder.fail((Object)itemstack);
        }
        playerEntity.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)itemstack);
    }
}

