/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.ldtteam.structurize.util.BlockUtils;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.items.AbstractItemScroll;
import com.minecolonies.core.network.messages.client.VanillaParticleMessage;
import com.minecolonies.core.util.TeleportHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public class ItemScrollColonyTP
extends AbstractItemScroll {
    public ItemScrollColonyTP(Item.Properties properties) {
        super("scroll_tp", properties);
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, Level world, ServerPlayer player) {
        if (world.random.nextInt(10) == 0) {
            player.displayClientMessage((Component)Component.translatableEscape((String)("minecolonies.scroll.failed" + (world.random.nextInt(10) + 1)), (Object[])new Object[0]).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), true);
            BlockPos pos = null;
            for (Direction dir : Direction.Plane.HORIZONTAL) {
                pos = BlockPosUtil.findAround(world, player.blockPosition().relative(dir, 10), 5, 5, (predWorld, predPos) -> BlockUtils.isAnySolid((BlockState)predWorld.getBlockState(predPos.below())) && predWorld.getBlockState(predPos).isAir() && predWorld.getBlockState(predPos.above()).isAir());
                if (pos == null) continue;
                break;
            }
            if (pos != null) {
                player.addEffect(new MobEffectInstance(MobEffects.CONFUSION, 140));
                player.teleportTo((ServerLevel)world, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), player.getYRot(), player.getXRot());
            }
            SoundUtils.playSoundForPlayer(player, SoundEvents.BAT_TAKEOFF, 0.4f, 1.0f);
        } else {
            this.doTeleport(player, this.getColony(itemStack), itemStack);
            SoundUtils.playSoundForPlayer(player, SoundEvents.ENCHANTMENT_TABLE_USE, 0.6f, 1.0f);
        }
        itemStack.shrink(1);
        return itemStack;
    }

    @Override
    protected boolean needsColony() {
        return true;
    }

    protected void doTeleport(ServerPlayer player, IColony colony, ItemStack stack) {
        TeleportHelper.colonyTeleport(player, colony);
    }

    public void onUseTick(Level worldIn, LivingEntity entity, ItemStack stack, int count) {
        if (!worldIn.isClientSide && worldIn.getGameTime() % 5L == 0L) {
            LivingEntity entity1 = entity;
            new VanillaParticleMessage(entity.getX(), entity.getY(), entity.getZ(), ParticleTypes.INSTANT_EFFECT).sendToTrackingEntity((Entity)entity1);
            new VanillaParticleMessage(entity.getX(), entity.getY(), entity.getZ(), ParticleTypes.INSTANT_EFFECT).sendToPlayer((ServerPlayer)entity);
        }
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext ctx, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        MutableComponent guiHint = Component.translatableEscape((String)"item.minecolonies.scroll_tp.tip", (Object[])new Object[0]);
        guiHint.setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)guiHint);
        MutableComponent colonyDesc = Component.translatable((String)"item.minecolonies.scroll.colony.none");
        IColony colony = this.getColonyView(stack);
        if (colony != null) {
            colonyDesc = Component.literal((String)colony.getName());
        }
        MutableComponent guiHint2 = Component.translatable((String)"item.minecolonies.scroll.colony.tip", (Object[])new Object[]{colonyDesc});
        guiHint2.setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD));
        tooltip.add((Component)guiHint2);
    }
}

