/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.items.AbstractItemScroll;
import com.minecolonies.core.network.messages.client.VanillaParticleMessage;
import com.minecolonies.core.util.TeleportHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemScrollColonyAreaTP
extends AbstractItemScroll {
    public ItemScrollColonyAreaTP(Item.Properties properties) {
        super("scroll_area_tp", properties);
    }

    @Override
    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        return 64;
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, Level world, ServerPlayer player) {
        if (world.random.nextInt(10) == 0) {
            player.displayClientMessage((Component)Component.translatableEscape((String)("minecolonies.scroll.failed" + (world.random.nextInt(10) + 1)), (Object[])new Object[0]).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), true);
            itemStack.shrink(1);
            if (!ItemStackUtils.isEmpty(itemStack)) {
                player.drop(itemStack.copy(), true, false);
                itemStack.setCount(0);
            }
            for (ServerPlayer sPlayer : this.getAffectedPlayers(player)) {
                SoundUtils.playSoundForPlayer(sPlayer, SoundEvents.EVOKER_PREPARE_SUMMON, 0.3f, 1.0f);
            }
        } else {
            for (ServerPlayer sPlayer : this.getAffectedPlayers(player)) {
                this.doTeleport(sPlayer, this.getColony(itemStack), itemStack);
                SoundUtils.playSoundForPlayer(sPlayer, SoundEvents.UI_TOAST_CHALLENGE_COMPLETE, 0.1f, 1.0f);
            }
            itemStack.shrink(1);
        }
        return itemStack;
    }

    @Override
    protected boolean needsColony() {
        return true;
    }

    protected void doTeleport(ServerPlayer player, IColony colony, ItemStack stack) {
        TeleportHelper.colonyTeleport(player, colony);
    }

    public void onUseTick(Level worldIn, LivingEntity entity, ItemStack stack, int count) {
        if (!worldIn.isClientSide && worldIn.getGameTime() % 5L == 0L && entity instanceof Player) {
            ServerPlayer sPlayer = (ServerPlayer)entity;
            for (Entity entity2 : this.getAffectedPlayers(sPlayer)) {
                new VanillaParticleMessage(entity2.getX(), entity2.getY(), entity2.getZ(), ParticleTypes.INSTANT_EFFECT).sendToTrackingEntity(entity2);
            }
            new VanillaParticleMessage(sPlayer.getX(), sPlayer.getY(), sPlayer.getZ(), ParticleTypes.INSTANT_EFFECT).sendToPlayer(sPlayer);
        }
    }

    private List<ServerPlayer> getAffectedPlayers(ServerPlayer user) {
        return user.level().getEntitiesOfClass(ServerPlayer.class, user.getBoundingBox().inflate(10.0, 2.0, 10.0));
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext ctx, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        MutableComponent guiHint = Component.translatableEscape((String)"item.minecolonies.scroll_area_tp.tip", (Object[])new Object[0]);
        guiHint.setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)guiHint);
        MutableComponent colonyDesc = Component.translatable((String)"item.minecolonies.scroll.colony.none");
        IColony colony = this.getColonyView(stack);
        if (colony != null) {
            colonyDesc = Component.literal((String)colony.getName());
        }
        MutableComponent guiHint2 = Component.translatableEscape((String)"item.minecolonies.scroll.colony.tip", (Object[])new Object[]{colonyDesc});
        guiHint2.setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD));
        tooltip.add((Component)guiHint2);
    }
}

