/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.items.AbstractItemScroll;
import com.minecolonies.core.network.messages.client.VanillaParticleMessage;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemScrollBuff
extends AbstractItemScroll {
    public ItemScrollBuff(Item.Properties properties) {
        super("scroll_buff", properties);
    }

    @Override
    protected ItemStack onItemUseSuccess(ItemStack itemStack, Level world, ServerPlayer player) {
        if (world.random.nextInt(8) > 0) {
            for (LivingEntity entity : world.getEntitiesOfClass(EntityCitizen.class, player.getBoundingBox().inflate(15.0, 2.0, 15.0))) {
                this.addRegenerationWithParticles(entity);
            }
            this.addRegenerationWithParticles((LivingEntity)player);
            new VanillaParticleMessage(player.getX(), player.getY(), player.getZ(), ParticleTypes.HEART).sendToPlayer(player);
            SoundUtils.playSoundForPlayer(player, SoundEvents.PLAYER_LEVELUP, 0.2f, 1.0f);
        } else {
            player.displayClientMessage((Component)Component.translatableEscape((String)("minecolonies.scroll.failed" + (world.random.nextInt(10) + 1)), (Object[])new Object[0]).setStyle(Style.EMPTY.withColor(ChatFormatting.GOLD)), true);
            player.addEffect(new MobEffectInstance(MobEffects.BLINDNESS, 200));
            SoundUtils.playSoundForPlayer(player, SoundEvents.TOTEM_USE, 0.04f, 1.0f);
        }
        itemStack.shrink(1);
        return itemStack;
    }

    private void addRegenerationWithParticles(LivingEntity entity) {
        entity.addEffect(new MobEffectInstance(MobEffects.REGENERATION, 1200));
        new VanillaParticleMessage(entity.getX(), entity.getY(), entity.getZ(), ParticleTypes.HEART).sendToTrackingEntity((Entity)entity);
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext ctx, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        MutableComponent guiHint = Component.translatableEscape((String)"item.minecolonies.scroll_buff.tip", (Object[])new Object[0]);
        guiHint.setStyle(Style.EMPTY.withColor(ChatFormatting.DARK_GREEN));
        tooltip.add((Component)guiHint);
    }

    @Override
    protected boolean needsColony() {
        return false;
    }
}

