/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.items;

import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.blocks.MinecoloniesCropBlock;
import com.minecolonies.core.blocks.MinecoloniesFarmland;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FarmBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import org.jetbrains.annotations.NotNull;

public class ItemCrop
extends BlockItem {
    @Nullable
    private final TagKey<Biome> preferredBiome;

    public ItemCrop(@NotNull MinecoloniesCropBlock cropBlock, @NotNull Item.Properties builder, @Nullable TagKey<Biome> preferredBiome) {
        super((Block)cropBlock, builder.food(new FoodProperties.Builder().nutrition(1).saturationModifier(0.3f).build()));
        this.preferredBiome = preferredBiome;
    }

    protected boolean canPlace(BlockPlaceContext ctx, @NotNull BlockState state) {
        Player player = ctx.getPlayer();
        if (!player.isCreative()) {
            BlockPos clickedPos = ctx.getClickedPos().below();
            BlockState worldState = ctx.getLevel().getBlockState(clickedPos);
            if (ctx.getLevel().isClientSide && (worldState.getBlock() instanceof MinecoloniesFarmland || worldState.getBlock() instanceof FarmBlock)) {
                MessageUtils.format((Component)Component.translatable((String)"com.minecolonies.core.crop.cantplant")).sendTo(player);
            }
            return false;
        }
        CollisionContext collisioncontext = player == null ? CollisionContext.empty() : CollisionContext.of((Entity)player);
        return (!this.mustSurvive() || state.canSurvive((LevelReader)ctx.getLevel(), ctx.getClickedPos())) && ctx.getLevel().isUnobstructed(state, ctx.getClickedPos(), collisioncontext);
    }

    public void appendHoverText(@NotNull ItemStack stack, @Nullable Item.TooltipContext ctx, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        tooltip.add((Component)Component.translatable((String)"com.minecolonies.core.item.crop.tooltip").withStyle(ChatFormatting.GRAY));
        if (this.preferredBiome != null && ctx.level() != null) {
            tooltip.add((Component)Component.translatable((String)("com.minecolonies.core.item.crop.tooltip.biome." + this.preferredBiome.location().getPath())));
            if (ctx.level().getBiome(Minecraft.getInstance().player.blockPosition()).is(this.preferredBiome)) {
                tooltip.add((Component)Component.translatable((String)"com.minecolonies.core.item.crop.tooltip.biome.match").withStyle(ChatFormatting.GREEN));
            } else {
                tooltip.add((Component)Component.translatable((String)"com.minecolonies.core.item.crop.tooltip.biome.nomatch").withStyle(ChatFormatting.RED));
            }
        }
        tooltip.add((Component)Component.translatable((String)"com.minecolonies.core.item.crop.tooltip.hoe").withStyle(ChatFormatting.DARK_AQUA).withStyle(ChatFormatting.ITALIC));
    }

    public boolean canBePlantedIn(Holder<Biome> biome) {
        return this.preferredBiome == null || biome.is(this.preferredBiome);
    }
}

