/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.visitor;

import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.permissions.Action;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.location.ILocation;
import com.minecolonies.api.configuration.ServerConfiguration;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenColonyHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenExperienceHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenInventoryHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenJobHandler;
import com.minecolonies.api.entity.citizen.citizenhandlers.ICitizenSleepHandler;
import com.minecolonies.api.inventory.InventoryCitizen;
import com.minecolonies.api.inventory.container.ContainerCitizenInventory;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.api.util.constant.TypeConstants;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.client.gui.WindowInteraction;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.TavernBuildingModule;
import com.minecolonies.core.entity.ai.minimal.EntityAIInteractToggleAble;
import com.minecolonies.core.entity.ai.minimal.LookAtEntityGoal;
import com.minecolonies.core.entity.ai.minimal.LookAtEntityInteractGoal;
import com.minecolonies.core.entity.ai.visitor.EntityAIVisitor;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenExperienceHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenInventoryHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenJobHandler;
import com.minecolonies.core.entity.citizen.citizenhandlers.CitizenSleepHandler;
import com.minecolonies.core.entity.pathfinding.navigation.MovementHandler;
import com.minecolonies.core.entity.visitor.VisitorColonyHandler;
import com.minecolonies.core.network.messages.client.ItemParticleEffectMessage;
import com.minecolonies.core.network.messages.server.colony.OpenInventoryMessage;
import com.minecolonies.core.util.citizenutils.CitizenItemUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisitorCitizen
extends AbstractEntityCitizen {
    private ICitizenExperienceHandler citizenExperienceHandler;
    private int citizenId = 0;
    @Nullable
    private ICitizenData citizenData;
    private ICitizenInventoryHandler citizenInventoryHandler = new CitizenInventoryHandler(this);
    private ICitizenColonyHandler citizenColonyHandler = new VisitorColonyHandler(this);
    private ICitizenJobHandler citizenJobHandler = new CitizenJobHandler(this);
    private ICitizenSleepHandler citizenSleepHandler = new CitizenSleepHandler(this);
    private ICitizenDataView citizenDataView;
    private ILocation location = null;

    public VisitorCitizen(EntityType<? extends PathfinderMob> type, Level world) {
        super(type, world);
        this.citizenExperienceHandler = new CitizenExperienceHandler(this);
        this.moveControl = new MovementHandler((Mob)this);
        this.setPersistenceRequired();
        this.setCustomNameVisible((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).alwaysRenderNameTag.get());
        this.initTasks();
    }

    private void initTasks() {
        int priority = 0;
        this.goalSelector.addGoal(priority, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(++priority, (Goal)new OpenDoorGoal((Mob)this, true));
        this.goalSelector.addGoal(priority, (Goal)new EntityAIInteractToggleAble(this, EntityAIInteractToggleAble.FENCE_TOGGLE, EntityAIInteractToggleAble.TRAP_TOGGLE, EntityAIInteractToggleAble.DOOR_TOGGLE));
        this.goalSelector.addGoal(++priority, (Goal)new LookAtEntityInteractGoal((Mob)this, Player.class, 3.0f, 0.2f));
        this.goalSelector.addGoal(++priority, (Goal)new LookAtEntityInteractGoal((Mob)this, EntityCitizen.class, 5.0f, 0.02f));
        this.goalSelector.addGoal(++priority, (Goal)new LookAtEntityGoal((Mob)this, LivingEntity.class, 6.0f));
        new EntityAIVisitor(this);
    }

    @Override
    public ILocation getLocation() {
        if (this.location == null) {
            this.location = StandardFactoryController.getInstance().getNewInstance(TypeConstants.ILOCATION, this, new Object[0]);
        }
        return this.location;
    }

    @Override
    public boolean hurt(@NotNull DamageSource damageSource, float damage) {
        if (!(damageSource.getEntity() instanceof EntityCitizen) && super.hurt(damageSource, damage)) {
            if (damageSource.getEntity() instanceof LivingEntity && damage > 1.01f) {
                Entity sourceEntity;
                IBuilding home = this.getCitizenData().getHomeBuilding();
                if (home != null && home.hasModule(BuildingModules.TAVERN_VISITOR)) {
                    TavernBuildingModule module = (TavernBuildingModule)home.getModule(BuildingModules.TAVERN_VISITOR);
                    for (Integer id : module.getExternalCitizens()) {
                        ICitizenData data = (ICitizenData)this.citizenColonyHandler.getColonyOrRegister().getVisitorManager().getCivilian(id);
                        if (data == null || !data.getEntity().isPresent() || data.getEntity().get().getLastHurtByMob() != null) continue;
                        data.getEntity().get().setLastHurtByMob((LivingEntity)damageSource.getEntity());
                    }
                }
                if ((sourceEntity = damageSource.getEntity()) instanceof Player) {
                    if (sourceEntity instanceof ServerPlayer) {
                        return damage <= 1.0f || this.getCitizenColonyHandler().getColonyOrRegister().getPermissions().hasPermission((Player)sourceEntity, Action.HURT_VISITOR);
                    }
                    IColonyView colonyView = IColonyManager.getInstance().getColonyView(this.getCitizenColonyHandler().getColonyId(), (ResourceKey<Level>)this.level().dimension());
                    return damage <= 1.0f || colonyView == null || colonyView.getPermissions().hasPermission((Player)sourceEntity, Action.HURT_VISITOR);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public ICitizenData getCitizenData() {
        return this.citizenData;
    }

    @Override
    public ICivilianData getCivilianData() {
        return this.citizenData;
    }

    @Override
    public void setCivilianData(@Nullable ICivilianData data) {
        if (data != null && data instanceof IVisitorData) {
            this.citizenData = (IVisitorData)data;
            data.initEntityValues();
        }
    }

    @Override
    @NotNull
    public InventoryCitizen getInventoryCitizen() {
        return this.getCitizenData().getInventory();
    }

    @Override
    @NotNull
    public IItemHandler getItemHandlerCitizen() {
        return this.getInventoryCitizen();
    }

    @Override
    public void markDirty(int time) {
        if (this.citizenData != null) {
            this.citizenData.markDirty(time);
        }
    }

    @Override
    public void setIsChild(boolean isChild) {
    }

    @Override
    public void playMoveAwaySound() {
    }

    @Override
    public void decreaseSaturationForAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(0.02);
            this.citizenData.markDirty(400);
        }
    }

    @Override
    public void decreaseSaturationForContinuousAction() {
        if (this.citizenData != null) {
            this.citizenData.decreaseSaturation(2.0E-4);
            this.citizenData.markDirty(2400);
        }
    }

    @Override
    public int getCivilianID() {
        return this.citizenId;
    }

    @Override
    public void setCitizenId(int id) {
        this.citizenId = id;
    }

    @Override
    public ICitizenExperienceHandler getCitizenExperienceHandler() {
        return this.citizenExperienceHandler;
    }

    @Override
    public ICitizenInventoryHandler getCitizenInventoryHandler() {
        return this.citizenInventoryHandler;
    }

    @Override
    public void setCitizenInventoryHandler(ICitizenInventoryHandler citizenInventoryHandler) {
        this.citizenInventoryHandler = citizenInventoryHandler;
    }

    @Override
    public ICitizenColonyHandler getCitizenColonyHandler() {
        return this.citizenColonyHandler;
    }

    @Override
    public void setCitizenColonyHandler(ICitizenColonyHandler citizenColonyHandler) {
        this.citizenColonyHandler = citizenColonyHandler;
    }

    @Override
    public ICitizenJobHandler getCitizenJobHandler() {
        return this.citizenJobHandler;
    }

    @Override
    public ICitizenSleepHandler getCitizenSleepHandler() {
        return this.citizenSleepHandler;
    }

    @Override
    public float getRotationYaw() {
        return this.getYRot();
    }

    @Override
    public float getRotationPitch() {
        return this.getXRot();
    }

    @Override
    public boolean isDead() {
        return !this.isAlive();
    }

    @Override
    public void setCitizenSleepHandler(ICitizenSleepHandler citizenSleepHandler) {
    }

    @Override
    public void setCitizenJobHandler(ICitizenJobHandler citizenJobHandler) {
        this.citizenJobHandler = citizenJobHandler;
    }

    @Override
    public void setCitizenExperienceHandler(ICitizenExperienceHandler citizenExperienceHandler) {
        this.citizenExperienceHandler = citizenExperienceHandler;
    }

    @Override
    public void callForHelp(Entity attacker, int guardHelpRange) {
    }

    @Nullable
    public AbstractContainerMenu createMenu(int id, Inventory playerInventory, Player playerEntity) {
        return new ContainerCitizenInventory(id, playerInventory, this.citizenColonyHandler.getColonyId(), this.citizenId);
    }

    public InteractionResult checkAndHandleImportantInteractions(Player player, @NotNull InteractionHand hand) {
        IColonyView iColonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)player.level().dimension());
        if (iColonyView != null && !iColonyView.getPermissions().hasPermission(player, Action.ACCESS_HUTS)) {
            return InteractionResult.FAIL;
        }
        if (!ItemStackUtils.isEmpty(player.getItemInHand(hand)) && player.getItemInHand(hand).getItem() instanceof NameTagItem) {
            return super.checkAndHandleImportantInteractions(player, hand);
        }
        InteractionResult result = this.directPlayerInteraction(player, hand);
        if (result != null) {
            return result;
        }
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).isClientSide) {
            if (player.isShiftKeyDown()) {
                new OpenInventoryMessage(iColonyView, this.getName().getString(), this.getId()).sendToServer();
            } else {
                ICitizenDataView citizenDataView = this.getCitizenDataView();
                if (citizenDataView != null) {
                    new WindowInteraction(citizenDataView).open();
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    private InteractionResult directPlayerInteraction(Player player, InteractionHand hand) {
        ItemStack usedStack = player.getItemInHand(hand);
        if (ItemStackUtils.ISFOOD.test(usedStack)) {
            if (!this.level().isClientSide()) {
                this.playSound(SoundEvents.GENERIC_EAT, 1.5f, (float)SoundUtils.getRandomPitch(this.getRandom()));
                new ItemParticleEffectMessage(usedStack.copy(), this.getX(), this.getY(), this.getZ(), this.getXRot(), this.getYRot(), this.getEyeHeight()).sendToTrackingEntity((Entity)this);
                ItemStackUtils.consumeFood(usedStack, this, player);
                MessageUtils.forCitizen(this, "com.minecolonies.coremod.interaction.visitor.food", new Object[0]).sendTo(player);
            }
            return InteractionResult.CONSUME;
        }
        return null;
    }

    @Override
    public ICitizenDataView getCitizenDataView() {
        if (this.citizenDataView == null) {
            IColonyView colonyView;
            this.citizenColonyHandler.updateColonyClient();
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.level().dimension())) != null) {
                this.citizenDataView = colonyView.getVisitor(this.citizenId);
                return this.citizenDataView;
            }
        } else {
            return this.citizenDataView;
        }
        return null;
    }

    @Override
    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_COLONY_ID, (Object)(this.citizenColonyHandler == null ? 0 : this.citizenColonyHandler.getColonyId()));
        builder.define(DATA_CITIZEN_ID, (Object)this.citizenId);
    }

    @Override
    public void aiStep() {
        super.aiStep();
        if (this.lastHurtByPlayerTime > 0) {
            this.markDirty(0);
        }
        if (CompatibilityUtils.getWorldFromCitizen((AbstractEntityCitizen)this).isClientSide) {
            IColonyView colonyView;
            this.citizenColonyHandler.updateColonyClient();
            if (this.citizenColonyHandler.getColonyId() != 0 && this.citizenId != 0 && this.getOffsetTicks() % 20 == 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.citizenColonyHandler.getColonyId(), (ResourceKey<Level>)this.level().dimension())) != null) {
                this.citizenDataView = colonyView.getVisitor(this.citizenId);
                this.getEntityData().set(DATA_STYLE, (Object)colonyView.getTextureStyleId());
            }
        } else {
            this.citizenColonyHandler.registerWithColony(this.citizenColonyHandler.getColonyId(), this.citizenId);
            if (this.tickCount % 500 == 0) {
                this.setCustomNameVisible((Boolean)((ServerConfiguration)MineColonies.getConfig().getServer()).alwaysRenderNameTag.get());
            }
        }
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putInt("colony", this.citizenColonyHandler.getColonyId());
        if (this.citizenData != null) {
            compound.putInt("citizen", this.citizenData.getId());
        }
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("colony")) {
            this.citizenColonyHandler.setColonyId(compound.getInt("colony"));
            if (compound.contains("citizen")) {
                this.citizenId = compound.getInt("citizen");
            }
        }
    }

    public void die(DamageSource cause) {
        IColony colony;
        super.die(cause);
        if (!this.level().isClientSide() && (colony = this.getCitizenColonyHandler().getColonyOrRegister()) != null && this.getCitizenData() != null) {
            colony.getVisitorManager().removeCivilian(this.getCitizenData());
            if (this.getCitizenData().getHomeBuilding() instanceof TavernBuildingModule) {
                TavernBuildingModule tavern = (TavernBuildingModule)((Object)this.getCitizenData().getHomeBuilding());
                tavern.setNoVisitorTime(this.level().getRandom().nextInt(5000) + 30000);
            }
            String deathLocation = BlockPosUtil.getString(this.blockPosition());
            MessageUtils.format("com.minecolonies.coremod.gui.tavern.visitordeath", this.getCitizenData().getName(), cause.getMsgId(), deathLocation).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(colony).forManagers();
        }
    }

    protected void dropEquipment() {
        for (int i = 0; i < this.getInventoryCitizen().getSlots(); ++i) {
            ItemStack itemstack = this.getCitizenData().getInventory().getStackInSlot(i);
            if (ItemStackUtils.getSize(itemstack) <= 0) continue;
            CitizenItemUtils.entityDropItem(this, itemstack);
        }
    }

    @Override
    public void queueSound(@NotNull SoundEvent soundEvent, BlockPos pos, int length, int repetitions) {
    }

    @Override
    public void queueSound(@NotNull SoundEvent soundEvent, BlockPos pos, int length, int repetitions, float volume, float pitch) {
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> dataAccessor) {
        super.onSyncedDataUpdated(dataAccessor);
        if (this.citizenColonyHandler != null) {
            this.citizenColonyHandler.onSyncDataUpdate(dataAccessor);
        }
    }

    public void setRemoved(Entity.RemovalReason reason) {
        this.citizenColonyHandler.onCitizenRemoved();
        super.setRemoved(reason);
    }

    @Override
    public int getTeamId() {
        return this.citizenColonyHandler.getColonyId();
    }
}

