/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.pathfinding.proxy;

import com.minecolonies.api.entity.pathfinding.proxy.IWalkToProxy;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.EntityUtils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractWalkToProxy
implements IWalkToProxy {
    private static final int MIN_RANGE_FOR_DIRECT_PATH = 400;
    private static final int MIN_DISTANCE = 25;
    private static final int PROXY_RANGE = 3;
    private final Mob entity;
    private final List<BlockPos> proxyList = new ArrayList<BlockPos>();
    private BlockPos currentProxy;
    private BlockPos target;

    protected AbstractWalkToProxy(Mob entity) {
        this.entity = entity;
    }

    @Override
    public boolean walkToBlock(@NotNull BlockPos target, int range) {
        return this.walkToBlock(target, range, true);
    }

    @Override
    public boolean walkToBlock(@NotNull BlockPos target, int range, boolean onMove) {
        double distanceProxyNextProxy;
        double distanceToPath;
        if (!target.equals((Object)this.target)) {
            this.resetProxyList();
            this.target = target;
        }
        BlockPos pos = BlockPos.containing((double)this.entity.getX(), (double)this.entity.getY(), (double)this.entity.getZ());
        double d = distanceToPath = this.careAboutY() ? (double)BlockPosUtil.getDistanceSquared(pos, target) : (double)BlockPosUtil.getDistanceSquared2D(pos, target);
        if (distanceToPath <= 400.0) {
            this.currentProxy = distanceToPath <= 25.0 ? null : target;
            this.proxyList.clear();
            return this.takeTheDirectPath(target, range, onMove);
        }
        if (this.currentProxy == null) {
            this.currentProxy = this.fillProxyList(target, distanceToPath);
        }
        double distanceToProxy = BlockPosUtil.getDistanceSquared(pos, this.currentProxy);
        double distanceToNextProxy = this.proxyList.isEmpty() ? (double)BlockPosUtil.getDistanceSquared(pos, target) : (double)BlockPosUtil.getDistanceSquared(pos, this.proxyList.get(0));
        double d2 = distanceProxyNextProxy = this.proxyList.isEmpty() ? (double)BlockPosUtil.getDistanceSquared(this.currentProxy, target) : (double)BlockPosUtil.getDistanceSquared(this.currentProxy, this.proxyList.get(0));
        if (distanceToProxy < 25.0 || distanceToNextProxy < distanceProxyNextProxy) {
            if (this.proxyList.isEmpty()) {
                this.currentProxy = target;
                return this.takeTheDirectPath(target, range, onMove);
            }
            this.currentProxy = this.proxyList.get(0);
            this.proxyList.remove(0);
        }
        if (this.currentProxy != null && !this.isLivingAtSiteWithMove(this.entity, this.currentProxy.getX(), this.currentProxy.getY(), this.currentProxy.getZ(), 3)) {
            return !onMove;
        }
        return !onMove;
    }

    @Override
    public List<BlockPos> getProxyList() {
        return new ArrayList<BlockPos>(this.proxyList);
    }

    @Override
    public void addToProxyList(BlockPos pos) {
        this.proxyList.add(pos);
    }

    @Override
    public boolean isLivingAtSiteWithMove(Mob entity, int x, int y, int z, int range) {
        if (!EntityUtils.isLivingAtSiteWithMove((LivingEntity)entity, x, y, z, range)) {
            EntityUtils.tryMoveLivingToXYZ(entity, x, y, z);
            return false;
        }
        return true;
    }

    @Override
    public Mob getEntity() {
        return this.entity;
    }

    private boolean takeTheDirectPath(@NotNull BlockPos target, int range, boolean onMove) {
        boolean arrived;
        BlockPos pos = BlockPos.containing((double)this.entity.getX(), (double)this.entity.getY(), (double)this.entity.getZ());
        if (onMove) {
            int targetY = this.careAboutY() ? target.getY() : this.entity.blockPosition().getY();
            arrived = this.isLivingAtSiteWithMove(this.entity, target.getX(), target.getY(), target.getZ(), range) || EntityUtils.isLivingAtSite((LivingEntity)this.entity, target.getX(), targetY, target.getZ(), range);
        } else {
            boolean bl = arrived = !EntityUtils.isLivingAtSite((LivingEntity)this.entity, target.getX(), target.getY(), target.getZ(), range);
        }
        if (arrived) {
            this.target = null;
        }
        return arrived;
    }

    @NotNull
    private BlockPos fillProxyList(@NotNull BlockPos target, double distanceToPath) {
        @Nullable BlockPos proxyPoint = this.getSpecializedProxy(target, distanceToPath);
        BlockPos pos = BlockPos.containing((double)this.entity.getX(), (double)this.entity.getY(), (double)this.entity.getZ());
        if (proxyPoint == null) {
            proxyPoint = this.getProxy(target, pos, distanceToPath);
        }
        if (!this.proxyList.isEmpty()) {
            this.proxyList.remove(0);
        }
        return proxyPoint;
    }

    private void resetProxyList() {
        this.currentProxy = null;
        this.proxyList.clear();
    }

    @NotNull
    protected BlockPos getProxy(@NotNull BlockPos target, @NotNull BlockPos position, double distanceToPath) {
        double weight = Double.MAX_VALUE;
        BlockPos proxyPoint = null;
        double distance = Double.MAX_VALUE;
        for (BlockPos wayPoint : this.getWayPoints()) {
            double simpleDistance = this.careAboutY() ? (double)BlockPosUtil.getDistanceSquared(position, wayPoint) : (double)BlockPosUtil.getDistanceSquared2D(position, wayPoint);
            double d = this.careAboutY() ? (double)BlockPosUtil.getDistanceSquared(wayPoint, target) : (double)BlockPosUtil.getDistanceSquared2D(wayPoint, target);
            double targetDistance = d;
            double currentWeight = simpleDistance * simpleDistance + targetDistance + targetDistance;
            if (!(currentWeight < weight) || !(targetDistance * 1.5 < distanceToPath) || !(simpleDistance > 25.0) || !(simpleDistance < distanceToPath) || this.proxyList.contains(wayPoint)) continue;
            proxyPoint = wayPoint;
            weight = currentWeight;
            distance = targetDistance;
        }
        if (this.proxyList.contains(proxyPoint)) {
            return target;
        }
        if (proxyPoint != null) {
            this.proxyList.add(proxyPoint);
            this.getProxy(target, proxyPoint, distance);
            return this.proxyList.get(0);
        }
        return target;
    }

    @Override
    public BlockPos getCurrentProxy() {
        return this.currentProxy;
    }

    @Override
    public void reset() {
        this.target = null;
    }
}

