/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.mobs.aitasks;

import com.minecolonies.api.entity.ai.statemachine.states.IState;
import com.minecolonies.api.entity.ai.statemachine.tickratestatemachine.ITickRateStateMachine;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesMonster;
import com.minecolonies.api.entity.mobs.RaiderMobUtils;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.SoundUtils;
import com.minecolonies.core.entity.ai.combat.AttackMoveAI;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.pathfinding.navigation.EntityNavigationUtils;
import com.minecolonies.core.entity.pathfinding.pathresults.PathResult;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class RaiderMeleeAI<T extends AbstractEntityMinecoloniesMonster>
extends AttackMoveAI<T> {
    public RaiderMeleeAI(T owner, ITickRateStateMachine<IState> stateMachine) {
        super(owner, stateMachine);
    }

    @Override
    protected void doAttack(LivingEntity target) {
        double damageToBeDealt = ((AbstractEntityMinecoloniesMonster)this.user).getAttribute((Holder)RaiderMobUtils.MOB_ATTACK_DAMAGE).getValue();
        ComponentContents componentContents = ((AbstractEntityMinecoloniesMonster)this.user).getName().getContents();
        if (componentContents instanceof TranslatableContents) {
            TranslatableContents translatableContents = (TranslatableContents)componentContents;
            target.hurt(target.level().damageSources().source(ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)new ResourceLocation("minecolonies", translatableContents.getKey().replace("entity.minecolonies.", ""))), (Entity)this.user), (float)damageToBeDealt);
        } else {
            target.hurt(target.level().damageSources().mobAttack((LivingEntity)this.user), (float)damageToBeDealt);
        }
        ((AbstractEntityMinecoloniesMonster)this.user).swing(InteractionHand.MAIN_HAND);
        ((AbstractEntityMinecoloniesMonster)this.user).playSound(SoundEvents.PLAYER_ATTACK_SWEEP, 1.0f, (float)SoundUtils.getRandomPitch(((AbstractEntityMinecoloniesMonster)this.user).getRandom()));
        target.setLastHurtByMob((LivingEntity)this.user);
    }

    @Override
    protected double getAttackDistance() {
        return ((AbstractEntityMinecoloniesMonster)this.user).getDifficulty() < 1.9 ? 2.5 : 2.9;
    }

    @Override
    protected int getAttackDelay() {
        return 30;
    }

    @Override
    protected PathResult moveInAttackPosition(LivingEntity target) {
        EntityNavigationUtils.walkToPos((AbstractEntityMinecoloniesMonster)this.user, target.blockPosition(), (int)this.getAttackDistance(), false, ((AbstractEntityMinecoloniesMonster)this.user).getDifficulty() < 2.3 ? 1.2 : 1.44);
        return ((AbstractEntityMinecoloniesMonster)this.user).getNavigation().getPathResult();
    }

    @Override
    protected boolean isAttackableTarget(LivingEntity target) {
        return target instanceof EntityCitizen && !target.isInvisible() || target instanceof Player && !((Player)target).isCreative() && !target.isSpectator();
    }

    @Override
    protected boolean isWithinPersecutionDistance(LivingEntity target) {
        return (double)BlockPosUtil.getDistanceSquared(((AbstractEntityMinecoloniesMonster)this.user).blockPosition(), target.blockPosition()) <= 4096.0;
    }

    @Override
    protected int getSearchRange() {
        return 0;
    }
}

