/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.requestsystem.management.manager;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import com.minecolonies.api.crafting.IRecipeManager;
import com.minecolonies.api.crafting.IRecipeStorage;
import com.minecolonies.api.util.NBTUtils;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.NotNull;

public class StandardRecipeManager
implements IRecipeManager {
    private static final String TAG_RECIPES = "recipes";
    private final BiMap<IToken<?>, IRecipeStorage> recipes = HashBiMap.create((int)4096);
    private ImmutableMap<IToken<?>, IRecipeStorage> cache = null;
    private final Set<IToken<?>> usedRecipes = new HashSet();
    private boolean dirty = false;
    private ListTag nbtCache = null;

    @Override
    public ImmutableMap<IToken<?>, IRecipeStorage> getRecipes() {
        if (this.cache == null) {
            this.cache = ImmutableMap.copyOf(this.recipes);
        }
        return this.cache;
    }

    @Override
    public IRecipeStorage getRecipe(IToken<?> token) {
        return (IRecipeStorage)this.recipes.get(token);
    }

    @Override
    public IToken<?> addRecipe(IRecipeStorage storage) {
        this.recipes.put(storage.getToken(), (Object)storage);
        this.registerUse(storage.getToken());
        this.cache = null;
        this.dirty = true;
        return storage.getToken();
    }

    @Override
    public IToken<?> checkOrAddRecipe(IRecipeStorage storage) {
        IToken<?> token = this.getRecipeId(storage);
        if (token == null) {
            return this.addRecipe(storage);
        }
        this.registerUse(token);
        return token;
    }

    @Override
    public IToken<?> getRecipeId(IRecipeStorage storage) {
        return (IToken)this.recipes.inverse().get((Object)storage);
    }

    @Override
    public void write(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        if (this.dirty || this.nbtCache == null) {
            this.nbtCache = this.recipes.entrySet().stream().filter(recipeEntry -> this.usedRecipes.contains(recipeEntry.getKey())).map(entry -> StandardFactoryController.getInstance().serializeTag(provider, (IRecipeStorage)entry.getValue())).collect(NBTUtils.toListNBT());
        }
        compound.put(TAG_RECIPES, (Tag)this.nbtCache);
        this.dirty = false;
    }

    @Override
    public void read(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        ListTag list = compound.getList(TAG_RECIPES, 10);
        for (int i = 0; i < list.size(); ++i) {
            IRecipeStorage recipe = (IRecipeStorage)StandardFactoryController.getInstance().deserializeTag(provider, list.getCompound(i));
            if (recipe == null || this.recipes.containsValue((Object)recipe) || recipe.getCleanedInput().isEmpty() || recipe.getPrimaryOutput().isEmpty() && recipe.getLootTable() == null && recipe.getAlternateOutputs().isEmpty()) continue;
            try {
                this.recipes.put(recipe.getToken(), (Object)recipe);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.cache = null;
        this.nbtCache = list;
    }

    @Override
    public void reset() {
        this.recipes.clear();
        this.usedRecipes.clear();
    }

    @Override
    public void registerUse(IToken<?> token) {
        if (this.usedRecipes.contains(token)) {
            return;
        }
        this.usedRecipes.add(token);
        this.dirty = true;
    }
}

