/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.events.raid.pirateEvent;

import com.ldtteam.structurize.storage.ServerFutureProcessor;
import com.ldtteam.structurize.storage.StructurePacks;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.EventStatus;
import com.minecolonies.api.colony.colonyEvents.IColonyEvent;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.colony.events.raid.AbstractShipRaidEvent;
import com.minecolonies.core.colony.events.raid.pirateEvent.ShipBasedRaiderUtils;
import com.minecolonies.core.entity.pathfinding.PathfindingUtils;
import java.util.concurrent.Future;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.pathfinder.Path;
import org.jetbrains.annotations.NotNull;

public class DrownedPirateRaidEvent
extends AbstractShipRaidEvent {
    public static final ResourceLocation PIRATE_RAID_EVENT_TYPE_ID = new ResourceLocation("minecolonies", "drowned_pirate_raid");
    public static final String SHIP_NAME = "sunk_ship";
    public static final int DEPTH_REQ = 13;

    public DrownedPirateRaidEvent(@NotNull IColony colony) {
        super(colony);
    }

    @Override
    public String getShipDesc() {
        return SHIP_NAME;
    }

    @Override
    public ResourceLocation getEventTypeID() {
        return PIRATE_RAID_EVENT_TYPE_ID;
    }

    @Override
    public void onStart() {
        this.status = EventStatus.PREPARING;
        ServerFutureProcessor.queueBlueprint((ServerFutureProcessor.BlueprintProcessingData)new ServerFutureProcessor.BlueprintProcessingData((Future)StructurePacks.getBlueprintFuture((String)"Minecolonies Original", (String)("decorations/ships/" + this.shipSize.schematicPrefix + this.getShipDesc() + ".blueprint"), (HolderLookup.Provider)this.colony.getWorld().registryAccess()), this.colony.getWorld(), blueprint -> {
            blueprint.setRotationMirror(this.shipRotationMirror, this.colony.getWorld());
            if (this.spawnPathResult != null && this.spawnPathResult.isDone()) {
                BlockPos endpoint;
                Path path = this.spawnPathResult.getPath();
                if (path != null && path.canReach() && ShipBasedRaiderUtils.canPlaceShipAt(endpoint = path.getEndNode().asBlockPos().below(), blueprint, this.colony.getWorld(), 13)) {
                    this.spawnPoint = endpoint;
                }
                this.wayPoints = ShipBasedRaiderUtils.createWaypoints(this.colony.getWorld(), path, 30);
            }
            if (!ShipBasedRaiderUtils.canPlaceShipAt(this.spawnPoint, blueprint, this.colony.getWorld(), 13)) {
                this.spawnPoint = this.spawnPoint.below();
            }
            while (PathfindingUtils.isLiquid(this.colony.getWorld().getBlockState(this.spawnPoint))) {
                this.spawnPoint = this.spawnPoint.below();
            }
            if (!ShipBasedRaiderUtils.spawnPirateShip(this.spawnPoint, this.colony, blueprint, this)) {
                this.status = EventStatus.CANCELED;
                return;
            }
            this.updateRaidBar();
            MessageUtils.format("event.minecolonies.raidmessage_u" + this.shipSize.messageID, BlockPosUtil.calcDirection(this.colony.getCenter(), this.spawnPoint).getLongText(), this.colony.getName()).withPriority(MessageUtils.MessagePriority.DANGER).sendTo(this.colony).forManagers();
            this.colony.markDirty();
        }));
    }

    public static IColonyEvent loadFromNBT(@NotNull IColony colony, @NotNull CompoundTag compound, @NotNull HolderLookup.Provider provider) {
        DrownedPirateRaidEvent raidEvent = new DrownedPirateRaidEvent(colony);
        raidEvent.deserializeNBT(provider, compound);
        return raidEvent;
    }

    @Override
    public boolean isUnderWater() {
        return true;
    }

    @Override
    public EntityType<?> getNormalRaiderType() {
        return ModEntities.DROWNED_PIRATE;
    }

    @Override
    public EntityType<?> getArcherRaiderType() {
        return null;
    }

    @Override
    public EntityType<?> getBossRaiderType() {
        return ModEntities.DROWNED_CHIEFPIRATE;
    }

    @Override
    protected MutableComponent getDisplayName() {
        return Component.translatable((String)"com.minecolonies.coremod.raid.pirate.name");
    }

    @Override
    protected void updateRaidBar() {
        super.updateRaidBar();
        this.raidBar.setDarkenScreen(true);
    }
}

