/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.google.common.collect.ImmutableList;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.datalistener.DiseasesListener;
import com.minecolonies.core.datalistener.model.Disease;
import com.minecolonies.core.entity.ai.workers.util.Patient;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BedPart;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class BuildingHospital
extends AbstractBuilding {
    private static final String HOSPITAL_DESC = "hospital";
    private static final int MAX_BUILDING_LEVEL = 5;
    @NotNull
    private final Map<BlockPos, Integer> bedMap = new HashMap<BlockPos, Integer>();
    private final Map<Integer, Patient> patients = new HashMap<Integer, Patient>();

    public BuildingHospital(IColony c, BlockPos l) {
        super(c, l);
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return HOSPITAL_DESC;
    }

    @Override
    public int getMaxBuildingLevel() {
        return 5;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        ListTag bedTagList = compound.getList("beds", 10);
        for (int i = 0; i < bedTagList.size(); ++i) {
            CompoundTag bedCompound = bedTagList.getCompound(i);
            BlockPos bedPos = BlockPosUtil.read(bedCompound, "pos");
            if (this.bedMap.containsKey(bedPos)) continue;
            this.bedMap.put(bedPos, bedCompound.getInt("id"));
        }
        ListTag patientTagList = compound.getList("patients", 10);
        for (int i = 0; i < patientTagList.size(); ++i) {
            CompoundTag patientCompound = patientTagList.getCompound(i);
            int patientId = patientCompound.getInt("id");
            if (this.patients.containsKey(patientId)) continue;
            this.patients.put(patientId, new Patient(patientCompound));
        }
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        if (!this.bedMap.isEmpty()) {
            @NotNull ListTag bedTagList = new ListTag();
            for (Map.Entry<BlockPos, Integer> entry : this.bedMap.entrySet()) {
                CompoundTag bedCompound = new CompoundTag();
                BlockPosUtil.write(bedCompound, "pos", entry.getKey());
                bedCompound.putInt("id", entry.getValue().intValue());
                bedTagList.add((Object)bedCompound);
            }
            compound.put("beds", (Tag)bedTagList);
        }
        if (!this.patients.isEmpty()) {
            @NotNull ListTag patientTagList = new ListTag();
            for (Patient patient : this.patients.values()) {
                CompoundTag patientCompound = new CompoundTag();
                patient.write(patientCompound);
                patientTagList.add((Object)patientCompound);
            }
            compound.put("patients", (Tag)patientTagList);
        }
        return compound;
    }

    @Override
    public void registerBlockPosition(@NotNull BlockState blockState, @NotNull BlockPos pos, @NotNull Level world) {
        super.registerBlockPosition(blockState, pos, world);
        BlockPos registrationPosition = pos;
        if (blockState.getBlock() instanceof BedBlock) {
            if (blockState.getValue((Property)BedBlock.PART) == BedPart.FOOT) {
                registrationPosition = registrationPosition.relative((Direction)blockState.getValue((Property)BedBlock.FACING));
            }
            if (!this.bedMap.containsKey(registrationPosition)) {
                this.bedMap.put(registrationPosition, 0);
            }
        }
    }

    @NotNull
    public List<BlockPos> getBedList() {
        return ImmutableList.copyOf(this.bedMap.keySet());
    }

    public List<Patient> getPatients() {
        return ImmutableList.copyOf(this.patients.values());
    }

    public void removePatientFile(Patient patient) {
        this.patients.remove(patient.getId());
    }

    @Override
    public Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> getRequiredItemsAndAmount() {
        Map<Predicate<ItemStack>, Tuple<Integer, Boolean>> map = super.getRequiredItemsAndAmount();
        map.put(BuildingHospital::isCureItem, (Tuple<Integer, Boolean>)new Tuple((Object)10, (Object)false));
        return map;
    }

    private static boolean isCureItem(ItemStack stack) {
        for (Disease disease : DiseasesListener.getDiseases()) {
            Iterator<ItemStorage> iterator = disease.cureItems().iterator();
            if (!iterator.hasNext()) continue;
            ItemStorage cureItem = iterator.next();
            return Disease.isCureItem(stack, cureItem);
        }
        return false;
    }

    public void checkOrCreatePatientFile(int citizenId) {
        if (!this.patients.containsKey(citizenId)) {
            this.patients.put(citizenId, new Patient(citizenId));
        }
    }

    public void registerPatient(BlockPos bedPos, int citizenId) {
        this.bedMap.put(bedPos, citizenId);
        this.setBedOccupation(bedPos, citizenId != 0);
    }

    private void setBedOccupation(BlockPos bedPos, boolean occupied) {
        BlockState state = this.colony.getWorld().getBlockState(bedPos);
        if (state.is(BlockTags.BEDS)) {
            this.colony.getWorld().setBlock(bedPos, (BlockState)state.setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(occupied)), 3);
            BlockPos feetPos = bedPos.relative(((Direction)state.getValue((Property)BedBlock.FACING)).getOpposite());
            BlockState feetState = this.colony.getWorld().getBlockState(feetPos);
            if (feetState.is(BlockTags.BEDS)) {
                this.colony.getWorld().setBlock(feetPos, (BlockState)feetState.setValue((Property)BedBlock.OCCUPIED, (Comparable)Boolean.valueOf(occupied)), 3);
            }
        }
    }

    @Override
    public void onWakeUp() {
        for (Map.Entry<BlockPos, Integer> entry : new ArrayList<Map.Entry<BlockPos, Integer>>(this.bedMap.entrySet())) {
            BlockState state = this.colony.getWorld().getBlockState(entry.getKey());
            if (state.getBlock() instanceof BedBlock) {
                if (entry.getValue() == 0 && ((Boolean)state.getValue((Property)BedBlock.OCCUPIED)).booleanValue()) {
                    this.setBedOccupation(entry.getKey(), false);
                    continue;
                }
                if (entry.getValue() == 0) continue;
                ICitizenData citizen = this.colony.getCitizenManager().getCivilian(entry.getValue());
                if (citizen != null) {
                    if (((Boolean)state.getValue((Property)BedBlock.OCCUPIED)).booleanValue()) {
                        if (citizen.isAsleep() && !citizen.getEntity().isEmpty() && !(citizen.getEntity().get().blockPosition().distSqr((Vec3i)entry.getKey()) > 2.0)) continue;
                        this.setBedOccupation(entry.getKey(), false);
                        this.bedMap.put(entry.getKey(), 0);
                        continue;
                    }
                    if (!citizen.isAsleep() || !citizen.getEntity().isPresent() || !(citizen.getEntity().get().blockPosition().distSqr((Vec3i)entry.getKey()) < 2.0)) continue;
                    this.setBedOccupation(entry.getKey(), true);
                    continue;
                }
                this.bedMap.put(entry.getKey(), 0);
                continue;
            }
            this.bedMap.remove(entry.getKey());
        }
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (BuildingHospital.isCureItem(stack)) {
            return false;
        }
        return super.canEat(stack);
    }
}

