/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.workerbuildings;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.modules.settings.ISettingKey;
import com.minecolonies.api.colony.workorders.IBuilderWorkOrder;
import com.minecolonies.api.colony.workorders.IServerWorkOrder;
import com.minecolonies.api.equipment.ModEquipmentTypes;
import com.minecolonies.api.equipment.registry.EquipmentTypeEntry;
import com.minecolonies.api.util.ItemStackUtils;
import com.minecolonies.api.util.MessageUtils;
import com.minecolonies.core.client.gui.huts.WindowHutBuilderModule;
import com.minecolonies.core.colony.buildings.AbstractBuildingStructureBuilder;
import com.minecolonies.core.colony.buildings.modules.BuildingModules;
import com.minecolonies.core.colony.buildings.modules.settings.BuilderModeSetting;
import com.minecolonies.core.colony.buildings.modules.settings.SettingKey;
import com.minecolonies.core.colony.buildings.modules.settings.StringSetting;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingBuilderView;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BuildingBuilder
extends AbstractBuildingStructureBuilder {
    public static final ISettingKey<StringSetting> MODE = new SettingKey<StringSetting>(StringSetting.class, new ResourceLocation("minecolonies", "mode"));
    public static final ISettingKey<BuilderModeSetting> BUILDING_MODE = new SettingKey<BuilderModeSetting>(BuilderModeSetting.class, new ResourceLocation("minecolonies", "buildmode"));
    public static final String MANUAL_SETTING = "com.minecolonies.core.builder.setting.manual";
    public static final String AUTO_SETTING = "com.minecolonies.core.builder.setting.automatic";
    private static final String BUILDER = "builder";
    private boolean purgedMobsToday = false;

    public BuildingBuilder(IColony c, BlockPos l) {
        super(c, l);
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.pickaxe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.shovel.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.axe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.hoe.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
        this.keepX.put(itemStack -> ItemStackUtils.hasEquipmentLevel(itemStack, (EquipmentTypeEntry)ModEquipmentTypes.shears.get(), 0, this.getMaxEquipmentLevel()), new Tuple((Object)1, (Object)true));
    }

    @Override
    @NotNull
    public String getSchematicName() {
        return BUILDER;
    }

    @Override
    public void onWakeUp() {
        this.purgedMobsToday = false;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        super.deserializeNBT(provider, compound);
        this.purgedMobsToday = compound.getBoolean("purgedMobs");
    }

    @Override
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = super.serializeNBT(provider);
        compound.putBoolean("purgedMobs", this.purgedMobsToday);
        return compound;
    }

    public void setPurgedMobsToday(boolean purgedMobsToday) {
        this.purgedMobsToday = purgedMobsToday;
    }

    public boolean hasPurgedMobsToday() {
        return this.purgedMobsToday;
    }

    public boolean getManualMode() {
        return this.getSetting(MODE).getValue().equals(MANUAL_SETTING);
    }

    public void setWorkOrder(int orderId, ServerPlayer serverPlayer) {
        ICitizenData citizen = this.getModule(BuildingModules.BUILDER_WORK).getFirstCitizen();
        if (citizen == null) {
            MessageUtils.format("tile.blockhut.noworkerassigned", new Object[0]).sendTo(new Player[]{serverPlayer});
            return;
        }
        IServerWorkOrder wo = this.getColony().getWorkManager().getWorkOrder(orderId);
        if (!(wo instanceof IBuilderWorkOrder)) {
            MessageUtils.format("tile.blockhut.notforbuilder", new Object[0]).sendTo(new Player[]{serverPlayer});
            return;
        }
        if (!wo.getClaimedBy().equals((Object)BlockPos.ZERO)) {
            MessageUtils.format("tile.blockhut.alreadyclaimed", new Object[0]).sendTo(new Player[]{serverPlayer});
            return;
        }
        if (this.hasWorkOrder()) {
            wo.setClaimedBy(this.getID());
            this.getColony().getWorkManager().setDirty(true);
            return;
        }
        if (((IBuilderWorkOrder)wo).canBuildIgnoringDistance(this, this.getPosition(), this.getBuildingLevel())) {
            this.setWorkOrder(wo);
            wo.setClaimedBy(this.getID());
            this.getColony().getWorkManager().setDirty(true);
            this.markDirty();
        } else {
            MessageUtils.format("tile.blockhut.cannotbuild", new Object[0]).sendTo(new Player[]{serverPlayer});
        }
    }

    @Override
    public boolean canBeBuiltByBuilder(int newLevel) {
        return this.getBuildingLevel() + 1 == newLevel;
    }

    @Override
    public boolean canAssignCitizens() {
        return true;
    }

    @Override
    public boolean canEat(ItemStack stack) {
        if (this.requiresResourceForBuilding(stack)) {
            return false;
        }
        return super.canEat(stack);
    }

    public static class View
    extends AbstractBuildingBuilderView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public BOWindow getWindow() {
            return new WindowHutBuilderModule(this);
        }
    }
}

