/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.moduleviews;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModuleView;
import com.minecolonies.api.colony.buildings.modules.IItemListModuleView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.util.Utils;
import com.minecolonies.core.client.gui.modules.building.ItemListModuleWindow;
import com.minecolonies.core.network.messages.server.colony.building.AssignFilterableItemMessage;
import com.minecolonies.core.network.messages.server.colony.building.ResetFilterableItemMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class ItemListModuleView
extends AbstractBuildingModuleView
implements IItemListModuleView {
    private final List<ItemStorage> listsOfItems = new ArrayList<ItemStorage>();
    private final String id;
    private final Function<IBuildingView, Set<ItemStorage>> allItems;
    private final boolean inverted;
    private final Component desc;

    public ItemListModuleView(String id, Component desc, boolean inverted, Function<IBuildingView, Set<ItemStorage>> allItems) {
        this.id = id;
        this.desc = desc;
        this.inverted = inverted;
        this.allItems = allItems;
    }

    @Override
    public void addItem(ItemStorage item) {
        new AssignFilterableItemMessage(this.buildingView, this.getProducer().getRuntimeID(), item, true).sendToServer();
        this.listsOfItems.add(item);
    }

    @Override
    public boolean isAllowedItem(ItemStorage item) {
        return this.listsOfItems.contains(item);
    }

    @Override
    public int getSize() {
        return this.listsOfItems.size();
    }

    @Override
    public void removeItem(ItemStorage item) {
        new AssignFilterableItemMessage(this.buildingView, this.getProducer().getRuntimeID(), item, false).sendToServer();
        this.listsOfItems.remove(item);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Function<IBuildingView, Set<ItemStorage>> getAllItems() {
        return this.allItems;
    }

    @Override
    public boolean isInverted() {
        return this.inverted;
    }

    @Override
    public void clearItems() {
        new ResetFilterableItemMessage(this.buildingView, this.getProducer().getRuntimeID()).sendToServer();
        this.listsOfItems.clear();
    }

    @Override
    public Component getDesc() {
        return this.desc;
    }

    @Override
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        this.listsOfItems.clear();
        int size = buf.readInt();
        for (int j = 0; j < size; ++j) {
            this.listsOfItems.add(new ItemStorage(Utils.deserializeCodecMess(buf)));
        }
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BOWindow getWindow() {
        return new ItemListModuleWindow(this, new ResourceLocation("minecolonies", "gui/layouthuts/layoutfilterablelist.xml"));
    }

    @Override
    public ResourceLocation getIconResourceLocation() {
        return new ResourceLocation("minecolonies", "textures/gui/modules/" + this.getId() + ".png");
    }
}

