/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.requestsystem.StandardFactoryController;
import com.minecolonies.api.colony.requestsystem.token.IToken;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;

public class WarehouseRequestQueueModule
extends AbstractBuildingModule
implements IPersistentModule {
    @NotNull
    private final List<IToken<?>> requestList = new ArrayList();

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        ListTag requestTagList = compound.getList("Request", 10);
        for (int i = 0; i < requestTagList.size(); ++i) {
            this.requestList.add((IToken)StandardFactoryController.getInstance().deserializeTag(provider, requestTagList.getCompound(i)));
        }
    }

    @Override
    public void serializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag compound) {
        if (!this.requestList.isEmpty()) {
            @NotNull ListTag requestTagList = new ListTag();
            for (IToken<?> token : this.requestList) {
                requestTagList.add((Object)StandardFactoryController.getInstance().serializeTag(provider, token));
            }
            compound.put("Request", (Tag)requestTagList);
        }
    }

    @Override
    public void serializeToView(RegistryFriendlyByteBuf buf) {
        super.serializeToView(buf);
        buf.writeInt(this.requestList.size());
        for (IToken<?> reqId : this.requestList) {
            StandardFactoryController.getInstance().serialize(buf, reqId);
        }
    }

    public void addRequest(IToken<?> requestToken) {
        this.requestList.add(requestToken);
        this.markDirty();
    }

    public List<IToken<?>> getMutableRequestList() {
        return this.requestList;
    }
}

