/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildings.modules;

import com.ldtteam.blockui.views.BOWindow;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.ICivilianData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.IVisitorData;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.ModBuildings;
import com.minecolonies.api.colony.buildings.modules.AbstractBuildingModule;
import com.minecolonies.api.colony.buildings.modules.IBuildingEventsModule;
import com.minecolonies.api.colony.buildings.modules.IDefinesCoreBuildingStatsModule;
import com.minecolonies.api.colony.buildings.modules.IPersistentModule;
import com.minecolonies.api.colony.buildings.modules.ITickingModule;
import com.minecolonies.api.colony.buildings.modules.stat.IStat;
import com.minecolonies.api.colony.interactionhandling.ChatPriority;
import com.minecolonies.api.sounds.TavernSounds;
import com.minecolonies.api.tileentities.AbstractTileEntityColonyBuilding;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.api.util.MathUtils;
import com.minecolonies.api.util.StatsUtil;
import com.minecolonies.core.client.gui.huts.WindowHutLiving;
import com.minecolonies.core.colony.buildings.views.LivingBuildingView;
import com.minecolonies.core.colony.interactionhandling.RecruitmentInteraction;
import com.minecolonies.core.datalistener.CustomVisitorListener;
import com.minecolonies.core.datalistener.RecruitmentItemsListener;
import com.minecolonies.core.network.messages.client.colony.PlayMusicAtPosMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TavernBuildingModule
extends AbstractBuildingModule
implements IDefinesCoreBuildingStatsModule,
IBuildingEventsModule,
IPersistentModule,
ITickingModule {
    public static final String TAG_VISITOR_ID = "visitor";
    private static final int TWENTY_MINUTES = 24000;
    private static final String TAG_NOVISITTIME = "novisit";
    private int musicCooldown = 0;
    private final List<Integer> externalCitizens = new ArrayList<Integer>();
    private final List<BlockPos> sitPositions = new ArrayList<BlockPos>();
    private final List<BlockPos> workPositions = new ArrayList<BlockPos>();
    private boolean initTags = false;
    private int noVisitorTime = 10000;

    @Override
    public IStat<Integer> getMaxInhabitants() {
        if (this.building.getBuildingLevel() <= 0) {
            return prev -> 0;
        }
        return prev -> 4;
    }

    @Override
    public void onPlayerEnterBuilding(Player player) {
        if (this.musicCooldown <= 0 && this.building.getBuildingLevel() > 0 && !this.building.getColony().isDay()) {
            int count = 0;
            BlockPos avg = BlockPos.ZERO;
            for (Integer id : this.externalCitizens) {
                Object data = this.building.getColony().getVisitorManager().getVisitor(id);
                if (data == null || data.getSittingPosition().equals((Object)BlockPos.ZERO)) continue;
                ++count;
                avg = avg.offset((Vec3i)data.getSittingPosition());
            }
            if (count < 2) {
                return;
            }
            avg = new BlockPos(avg.getX() / count, avg.getY() / count, avg.getZ() / count);
            PlayMusicAtPosMessage message = new PlayMusicAtPosMessage(TavernSounds.tavernTheme, avg, this.building.getColony().getWorld(), 0.7f, 1.0f);
            message.sendToPlayer(this.building.getColony().getPackageManager().getCloseSubscribers());
            this.musicCooldown = 24000;
        }
    }

    @Override
    public void onColonyTick(@NotNull IColony colony) {
        if (this.musicCooldown > 0) {
            this.musicCooldown -= 500;
        }
        this.externalCitizens.removeIf(id -> colony.getVisitorManager().getVisitor((int)id) == null);
        if (this.noVisitorTime > 0) {
            this.noVisitorTime -= 500;
        }
        if (this.building.getBuildingLevel() > 0 && this.externalCitizens.size() < 3 * this.building.getBuildingLevel() && this.noVisitorTime <= 0) {
            this.spawnVisitorInternal();
            this.noVisitorTime = colony.getWorld().getRandom().nextInt(3000) + 6000 / this.building.getBuildingLevel() * colony.getCitizenManager().getCurrentCitizenCount() / colony.getCitizenManager().getMaxCitizens();
        }
    }

    @Override
    public void onUpgradeComplete(int newlevel) {
        this.initTags = false;
    }

    private void spawnVisitorInternal() {
        IVisitorData visitorData = this.spawnVisitor();
        if (visitorData != null && !CustomVisitorListener.chanceCustomVisitors(visitorData)) {
            visitorData.triggerInteraction(new RecruitmentInteraction((Component)Component.translatable((String)("com.minecolonies.coremod.gui.chat.recruitstory" + (this.building.getColony().getWorld().random.nextInt(20) + 1)), (Object[])new Object[]{visitorData.getName().split(" ")[0]}), ChatPriority.IMPORTANT));
        }
    }

    @Nullable
    public IVisitorData spawnVisitor() {
        List<BlockPos> gatePositions;
        IBuilding gateHouseBuilding;
        RecruitmentItemsListener.RecruitCost cost = RecruitmentItemsListener.getRandomRecruitCost(this.building.getBuildingLevel());
        if (cost == null) {
            return null;
        }
        IVisitorData newCitizen = (IVisitorData)this.building.getColony().getVisitorManager().createAndRegisterCivilianData();
        newCitizen.setBedPos(this.building.getPosition());
        newCitizen.setHomeBuilding(this.building);
        newCitizen.getCitizenSkillHandler().init(cost.recruitLevel());
        ItemStack recruitCostItem = cost.recruitItem().copy();
        recruitCostItem.setCount(Math.min(cost.recruitItem().getMaxStackSize(), recruitCostItem.getCount() + MathUtils.RANDOM.nextInt(3)));
        newCitizen.setRecruitCosts(recruitCostItem);
        BlockPos gatePos = this.building.getColony().getBuildingManager().getRandomBuilding(b -> b.getBuildingType() == ModBuildings.gateHouse.get());
        BlockPos spawnPos = gatePos != null ? ((gateHouseBuilding = this.building.getColony().getBuildingManager().getBuilding(gatePos)) != null ? ((gatePositions = gateHouseBuilding.getLocationsFromTag("gate")).isEmpty() ? BlockPosUtil.findSpawnPosAround(this.building.getColony().getWorld(), gatePos) : BlockPosUtil.findSpawnPosAround(this.building.getColony().getWorld(), gatePositions.get(MathUtils.RANDOM.nextInt(gatePositions.size())))) : BlockPosUtil.findSpawnPosAround(this.building.getColony().getWorld(), gatePos)) : BlockPosUtil.findSpawnPosAround(this.building.getColony().getWorld(), this.building.getPosition());
        if (spawnPos == null) {
            spawnPos = this.building.getPosition();
        }
        this.building.getColony().getVisitorManager().spawnOrCreateCivilian(newCitizen, this.building.getColony().getWorld(), spawnPos, true);
        if (newCitizen.getEntity().isPresent()) {
            newCitizen.getEntity().get().setItemSlot(EquipmentSlot.FEET, cost.boots());
        }
        StatsUtil.trackStat(this.building, "new_visitors", 1);
        this.externalCitizens.add(newCitizen.getId());
        return newCitizen;
    }

    @Override
    public void serializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        ListTag visitorlist = new ListTag();
        for (Integer id : this.externalCitizens) {
            CompoundTag visitorCompound = new CompoundTag();
            visitorCompound.putInt(TAG_VISITOR_ID, id.intValue());
            visitorlist.add((Object)visitorCompound);
        }
        nbt.put("visitors", (Tag)visitorlist);
        nbt.putInt(TAG_NOVISITTIME, this.noVisitorTime);
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, CompoundTag nbt) {
        ListTag visitorlist = nbt.getList("visitors", 10);
        for (Tag data : visitorlist) {
            int id = ((CompoundTag)data).getInt(TAG_VISITOR_ID);
            ICitizenData citizenData = (ICitizenData)this.building.getColony().getVisitorManager().getCivilian(id);
            if (citizenData == null) continue;
            this.externalCitizens.add(id);
            citizenData.setHomeBuilding(this.building);
        }
        this.noVisitorTime = nbt.getInt(TAG_NOVISITTIME);
    }

    public BlockPos getFreeSitPosition() {
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>(this.getSitPositions());
        if (positions.isEmpty()) {
            return null;
        }
        for (Integer id : this.externalCitizens) {
            Object data = this.building.getColony().getVisitorManager().getVisitor(id);
            if (data == null) continue;
            positions.remove(data.getSittingPosition());
        }
        if (!positions.isEmpty()) {
            return (BlockPos)positions.get(this.building.getColony().getWorld().random.nextInt(positions.size()));
        }
        return null;
    }

    @Override
    public void onDestroyed() {
        for (Integer id : this.externalCitizens) {
            this.building.getColony().getVisitorManager().removeCivilian((ICivilianData)this.building.getColony().getVisitorManager().getVisitor(id));
        }
    }

    public List<Integer> getExternalCitizens() {
        return this.externalCitizens;
    }

    public BlockPos getWorkPos() {
        if (!this.getWorkPositions().isEmpty()) {
            return this.workPositions.get(this.building.getColony().getWorld().random.nextInt(this.workPositions.size()));
        }
        return null;
    }

    private List<BlockPos> getSitPositions() {
        this.initTagPositions();
        return this.sitPositions;
    }

    private List<BlockPos> getWorkPositions() {
        this.initTagPositions();
        return this.workPositions;
    }

    public void initTagPositions() {
        if (this.initTags) {
            return;
        }
        AbstractTileEntityColonyBuilding te = this.building.getTileEntity();
        if (te != null) {
            this.initTags = true;
            for (Map.Entry entry : te.getWorldTagPosMap().entrySet()) {
                if (((List)entry.getValue()).contains("sit")) {
                    this.sitPositions.add((BlockPos)entry.getKey());
                }
                if (((List)entry.getValue()).contains("sit_in")) {
                    this.sitPositions.add((BlockPos)entry.getKey());
                }
                if (((List)entry.getValue()).contains("sit_out")) {
                    this.sitPositions.add((BlockPos)entry.getKey());
                }
                if (!((List)entry.getValue()).contains("work")) continue;
                this.workPositions.add((BlockPos)entry.getKey());
            }
        }
    }

    public boolean removeCitizen(Integer id) {
        this.externalCitizens.remove(id);
        return false;
    }

    public void setNoVisitorTime(int noVisitorTime) {
        this.noVisitorTime = noVisitorTime;
    }

    public static class View
    extends LivingBuildingView {
        public View(IColonyView c, BlockPos l) {
            super(c, l);
        }

        @Override
        @NotNull
        public BOWindow getWindow() {
            return new WindowHutLiving(this);
        }
    }
}

