/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony.buildingextensions;

import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildingextensions.modules.IBuildingExtensionModule;
import com.minecolonies.api.colony.buildingextensions.registry.BuildingExtensionRegistries;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.util.BlockPosUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.RegistryFriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractBuildingExtension
implements IBuildingExtension {
    private final List<IBuildingExtensionModule> modules = new ArrayList<IBuildingExtensionModule>();
    private final BuildingExtensionRegistries.BuildingExtensionEntry buildingExtensionEntry;
    private final BlockPos position;
    @Nullable
    private BlockPos buildingId = null;
    private final IBuildingExtension.ExtensionId extensionId;

    protected AbstractBuildingExtension(@NotNull BuildingExtensionRegistries.BuildingExtensionEntry buildingExtensionEntry, @NotNull BlockPos position) {
        this.buildingExtensionEntry = buildingExtensionEntry;
        this.position = position;
        this.extensionId = new IBuildingExtension.ExtensionId(position, buildingExtensionEntry);
    }

    @Override
    @NotNull
    public List<IBuildingExtensionModule> getModules() {
        return this.modules;
    }

    @Override
    @NotNull
    public Class<IBuildingExtensionModule> getClassType() {
        return IBuildingExtensionModule.class;
    }

    @Override
    public void registerModule(@NotNull IBuildingExtensionModule module) {
        this.modules.add(module);
    }

    @Override
    @NotNull
    public final BuildingExtensionRegistries.BuildingExtensionEntry getBuildingExtensionType() {
        return this.buildingExtensionEntry;
    }

    @Override
    @NotNull
    public final BlockPos getPosition() {
        return this.position;
    }

    @Override
    @Nullable
    public final BlockPos getBuildingId() {
        return this.buildingId;
    }

    @Override
    public final void setBuilding(BlockPos buildingId) {
        this.buildingId = buildingId;
    }

    @Override
    public final void resetOwningBuilding() {
        this.buildingId = null;
    }

    @Override
    public final boolean isTaken() {
        return this.buildingId != null;
    }

    @Override
    public final int getSqDistance(IBuildingView building) {
        return (int)Math.sqrt(BlockPosUtil.getDistanceSquared(this.position, building.getPosition()));
    }

    @Override
    @NotNull
    public CompoundTag serializeNBT(@NotNull HolderLookup.Provider provider) {
        CompoundTag compound = new CompoundTag();
        if (this.buildingId != null) {
            BlockPosUtil.write(compound, "owner", this.buildingId);
        }
        return compound;
    }

    @Override
    public void deserializeNBT(@NotNull HolderLookup.Provider provider, @NotNull CompoundTag compound) {
        if (compound.contains("owner")) {
            this.buildingId = BlockPosUtil.read(compound, "owner");
        }
    }

    @Override
    public void serialize(@NotNull RegistryFriendlyByteBuf buf) {
        buf.writeBoolean(this.buildingId != null);
        if (this.buildingId != null) {
            buf.writeBlockPos(this.buildingId);
        }
    }

    @Override
    public void deserialize(@NotNull RegistryFriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            this.buildingId = buf.readBlockPos();
        }
    }

    @Override
    public int hashCode() {
        int result = this.position.hashCode();
        result = 31 * result + this.buildingExtensionEntry.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractBuildingExtension that = (AbstractBuildingExtension)o;
        if (!this.position.equals((Object)that.position)) {
            return false;
        }
        return this.buildingExtensionEntry.equals(that.buildingExtensionEntry);
    }

    @Override
    public IBuildingExtension.ExtensionId getId() {
        return this.extensionId;
    }
}

