/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.colony;

import com.google.common.collect.ImmutableMap;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.managers.interfaces.IGraveManager;
import com.minecolonies.api.util.BlockPosUtil;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class GraveManagerView
implements IGraveManager {
    private Map<BlockPos, Boolean> graves = ImmutableMap.of();

    @Override
    public void read(@NotNull CompoundTag compound) {
        ImmutableMap.Builder graves = ImmutableMap.builder();
        ListTag gravesTagList = compound.getList("graves", 10);
        for (int i = 0; i < gravesTagList.size(); ++i) {
            CompoundTag graveCompound = gravesTagList.getCompound(i);
            if (!graveCompound.contains("pos") || !graveCompound.contains("reserved")) continue;
            graves.put((Object)BlockPosUtil.read(graveCompound, "pos"), (Object)graveCompound.getBoolean("reserved"));
        }
        this.graves = graves.build();
    }

    @Override
    public void write(@NotNull CompoundTag compound) {
    }

    @Override
    public void onColonyTick(IColony colony) {
    }

    @Override
    public boolean reserveGrave(BlockPos pos) {
        return false;
    }

    @Override
    public void unReserveGrave(BlockPos pos) {
    }

    @Override
    public BlockPos reserveNextFreeGrave() {
        return null;
    }

    @Override
    public BlockPos createCitizenGrave(Level world, BlockPos pos, ICitizenData citizenData) {
        return null;
    }

    @Override
    @NotNull
    public Map<BlockPos, Boolean> getGraves() {
        return this.graves;
    }

    @Override
    public boolean addNewGrave(@NotNull BlockPos pos) {
        return false;
    }

    @Override
    public void removeGrave(@NotNull BlockPos pos) {
    }
}

